/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.PropertyDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesSummary> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(TimeSeriesSummary.getter(TimeSeriesSummary::assetId)).setter(TimeSeriesSummary.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(TimeSeriesSummary.getter(TimeSeriesSummary::propertyId)).setter(TimeSeriesSummary.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(TimeSeriesSummary.getter(TimeSeriesSummary::alias)).setter(TimeSeriesSummary.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> TIME_SERIES_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeSeriesId").getter(TimeSeriesSummary.getter(TimeSeriesSummary::timeSeriesId)).setter(TimeSeriesSummary.setter(Builder::timeSeriesId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeSeriesId").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(TimeSeriesSummary.getter(TimeSeriesSummary::dataTypeAsString)).setter(TimeSeriesSummary.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataTypeSpec").getter(TimeSeriesSummary.getter(TimeSeriesSummary::dataTypeSpec)).setter(TimeSeriesSummary.setter(Builder::dataTypeSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()}).build();
    private static final SdkField<Instant> TIME_SERIES_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timeSeriesCreationDate").getter(TimeSeriesSummary.getter(TimeSeriesSummary::timeSeriesCreationDate)).setter(TimeSeriesSummary.setter(Builder::timeSeriesCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeSeriesCreationDate").build()}).build();
    private static final SdkField<Instant> TIME_SERIES_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timeSeriesLastUpdateDate").getter(TimeSeriesSummary.getter(TimeSeriesSummary::timeSeriesLastUpdateDate)).setter(TimeSeriesSummary.setter(Builder::timeSeriesLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeSeriesLastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, PROPERTY_ID_FIELD, ALIAS_FIELD, TIME_SERIES_ID_FIELD, DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD, TIME_SERIES_CREATION_DATE_FIELD, TIME_SERIES_LAST_UPDATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String propertyId;
    private final String alias;
    private final String timeSeriesId;
    private final String dataType;
    private final String dataTypeSpec;
    private final Instant timeSeriesCreationDate;
    private final Instant timeSeriesLastUpdateDate;

    private TimeSeriesSummary(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.alias = builder.alias;
        this.timeSeriesId = builder.timeSeriesId;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.timeSeriesCreationDate = builder.timeSeriesCreationDate;
        this.timeSeriesLastUpdateDate = builder.timeSeriesLastUpdateDate;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public final String alias() {
        return this.alias;
    }

    public final String timeSeriesId() {
        return this.timeSeriesId;
    }

    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String dataTypeSpec() {
        return this.dataTypeSpec;
    }

    public final Instant timeSeriesCreationDate() {
        return this.timeSeriesCreationDate;
    }

    public final Instant timeSeriesLastUpdateDate() {
        return this.timeSeriesLastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesLastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesSummary)) {
            return false;
        }
        TimeSeriesSummary other = (TimeSeriesSummary)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.timeSeriesId(), other.timeSeriesId()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.dataTypeSpec(), other.dataTypeSpec()) && Objects.equals(this.timeSeriesCreationDate(), other.timeSeriesCreationDate()) && Objects.equals(this.timeSeriesLastUpdateDate(), other.timeSeriesLastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesSummary").add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("Alias", (Object)this.alias()).add("TimeSeriesId", (Object)this.timeSeriesId()).add("DataType", (Object)this.dataTypeAsString()).add("DataTypeSpec", (Object)this.dataTypeSpec()).add("TimeSeriesCreationDate", (Object)this.timeSeriesCreationDate()).add("TimeSeriesLastUpdateDate", (Object)this.timeSeriesLastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "timeSeriesId": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesId()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "dataTypeSpec": {
                return Optional.ofNullable(clazz.cast(this.dataTypeSpec()));
            }
            case "timeSeriesCreationDate": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesCreationDate()));
            }
            case "timeSeriesLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesLastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesSummary, T> g) {
        return obj -> g.apply((TimeSeriesSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String propertyId;
        private String alias;
        private String timeSeriesId;
        private String dataType;
        private String dataTypeSpec;
        private Instant timeSeriesCreationDate;
        private Instant timeSeriesLastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesSummary model) {
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.alias(model.alias);
            this.timeSeriesId(model.timeSeriesId);
            this.dataType(model.dataType);
            this.dataTypeSpec(model.dataTypeSpec);
            this.timeSeriesCreationDate(model.timeSeriesCreationDate);
            this.timeSeriesLastUpdateDate(model.timeSeriesLastUpdateDate);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getTimeSeriesId() {
            return this.timeSeriesId;
        }

        public final void setTimeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
        }

        @Override
        public final Builder timeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeSpec() {
            return this.dataTypeSpec;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        @Override
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final Instant getTimeSeriesCreationDate() {
            return this.timeSeriesCreationDate;
        }

        public final void setTimeSeriesCreationDate(Instant timeSeriesCreationDate) {
            this.timeSeriesCreationDate = timeSeriesCreationDate;
        }

        @Override
        public final Builder timeSeriesCreationDate(Instant timeSeriesCreationDate) {
            this.timeSeriesCreationDate = timeSeriesCreationDate;
            return this;
        }

        public final Instant getTimeSeriesLastUpdateDate() {
            return this.timeSeriesLastUpdateDate;
        }

        public final void setTimeSeriesLastUpdateDate(Instant timeSeriesLastUpdateDate) {
            this.timeSeriesLastUpdateDate = timeSeriesLastUpdateDate;
        }

        @Override
        public final Builder timeSeriesLastUpdateDate(Instant timeSeriesLastUpdateDate) {
            this.timeSeriesLastUpdateDate = timeSeriesLastUpdateDate;
            return this;
        }

        public TimeSeriesSummary build() {
            return new TimeSeriesSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesSummary> {
        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder alias(String var1);

        public Builder timeSeriesId(String var1);

        public Builder dataType(String var1);

        public Builder dataType(PropertyDataType var1);

        public Builder dataTypeSpec(String var1);

        public Builder timeSeriesCreationDate(Instant var1);

        public Builder timeSeriesLastUpdateDate(Instant var1);
    }
}

