/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;

public class ListWirelessDevicesIterable
implements SdkIterable<ListWirelessDevicesResponse> {
    private final IotWirelessClient client;
    private final ListWirelessDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWirelessDevicesIterable(IotWirelessClient client, ListWirelessDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWirelessDevicesResponseFetcher();
    }

    public Iterator<ListWirelessDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWirelessDevicesResponseFetcher
    implements SyncPageFetcher<ListWirelessDevicesResponse> {
        private ListWirelessDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListWirelessDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWirelessDevicesResponse nextPage(ListWirelessDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListWirelessDevicesIterable.this.client.listWirelessDevices(ListWirelessDevicesIterable.this.firstRequest);
            }
            return ListWirelessDevicesIterable.this.client.listWirelessDevices((ListWirelessDevicesRequest)((Object)ListWirelessDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

