/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.model.Cluster;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Request;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Response;

public class ListClustersV2Publisher
implements SdkPublisher<ListClustersV2Response> {
    private final KafkaAsyncClient client;
    private final ListClustersV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClustersV2Publisher(KafkaAsyncClient client, ListClustersV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClustersV2Publisher(KafkaAsyncClient client, ListClustersV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClustersV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClustersV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Cluster> clusterInfoList() {
        Function<ListClustersV2Response, Iterator> getIterator = response -> {
            if (response != null && response.clusterInfoList() != null) {
                return response.clusterInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClustersV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClustersV2ResponseFetcher
    implements AsyncPageFetcher<ListClustersV2Response> {
        private ListClustersV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClustersV2Response> nextPage(ListClustersV2Response previousPage) {
            if (previousPage == null) {
                return ListClustersV2Publisher.this.client.listClustersV2(ListClustersV2Publisher.this.firstRequest);
            }
            return ListClustersV2Publisher.this.client.listClustersV2((ListClustersV2Request)((Object)ListClustersV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

