/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.CapacitySpecification;
import software.amazon.awssdk.services.keyspaces.model.ColumnDefinition;
import software.amazon.awssdk.services.keyspaces.model.ColumnDefinitionListCopier;
import software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.PointInTimeRecovery;
import software.amazon.awssdk.services.keyspaces.model.TimeToLive;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTableRequest
extends KeyspacesRequest
implements ToCopyableBuilder<Builder, UpdateTableRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(UpdateTableRequest.getter(UpdateTableRequest::keyspaceName)).setter(UpdateTableRequest.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(UpdateTableRequest.getter(UpdateTableRequest::tableName)).setter(UpdateTableRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<List<ColumnDefinition>> ADD_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addColumns").getter(UpdateTableRequest.getter(UpdateTableRequest::addColumns)).setter(UpdateTableRequest.setter(Builder::addColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CapacitySpecification> CAPACITY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacitySpecification").getter(UpdateTableRequest.getter(UpdateTableRequest::capacitySpecification)).setter(UpdateTableRequest.setter(Builder::capacitySpecification)).constructor(CapacitySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecification").build()}).build();
    private static final SdkField<EncryptionSpecification> ENCRYPTION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionSpecification").getter(UpdateTableRequest.getter(UpdateTableRequest::encryptionSpecification)).setter(UpdateTableRequest.setter(Builder::encryptionSpecification)).constructor(EncryptionSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSpecification").build()}).build();
    private static final SdkField<PointInTimeRecovery> POINT_IN_TIME_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pointInTimeRecovery").getter(UpdateTableRequest.getter(UpdateTableRequest::pointInTimeRecovery)).setter(UpdateTableRequest.setter(Builder::pointInTimeRecovery)).constructor(PointInTimeRecovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeRecovery").build()}).build();
    private static final SdkField<TimeToLive> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ttl").getter(UpdateTableRequest.getter(UpdateTableRequest::ttl)).setter(UpdateTableRequest.setter(Builder::ttl)).constructor(TimeToLive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final SdkField<Integer> DEFAULT_TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("defaultTimeToLive").getter(UpdateTableRequest.getter(UpdateTableRequest::defaultTimeToLive)).setter(UpdateTableRequest.setter(Builder::defaultTimeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTimeToLive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, TABLE_NAME_FIELD, ADD_COLUMNS_FIELD, CAPACITY_SPECIFICATION_FIELD, ENCRYPTION_SPECIFICATION_FIELD, POINT_IN_TIME_RECOVERY_FIELD, TTL_FIELD, DEFAULT_TIME_TO_LIVE_FIELD));
    private final String keyspaceName;
    private final String tableName;
    private final List<ColumnDefinition> addColumns;
    private final CapacitySpecification capacitySpecification;
    private final EncryptionSpecification encryptionSpecification;
    private final PointInTimeRecovery pointInTimeRecovery;
    private final TimeToLive ttl;
    private final Integer defaultTimeToLive;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.addColumns = builder.addColumns;
        this.capacitySpecification = builder.capacitySpecification;
        this.encryptionSpecification = builder.encryptionSpecification;
        this.pointInTimeRecovery = builder.pointInTimeRecovery;
        this.ttl = builder.ttl;
        this.defaultTimeToLive = builder.defaultTimeToLive;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasAddColumns() {
        return this.addColumns != null && !(this.addColumns instanceof SdkAutoConstructList);
    }

    public final List<ColumnDefinition> addColumns() {
        return this.addColumns;
    }

    public final CapacitySpecification capacitySpecification() {
        return this.capacitySpecification;
    }

    public final EncryptionSpecification encryptionSpecification() {
        return this.encryptionSpecification;
    }

    public final PointInTimeRecovery pointInTimeRecovery() {
        return this.pointInTimeRecovery;
    }

    public final TimeToLive ttl() {
        return this.ttl;
    }

    public final Integer defaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddColumns() ? this.addColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeRecovery());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTimeToLive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasAddColumns() == other.hasAddColumns() && Objects.equals(this.addColumns(), other.addColumns()) && Objects.equals(this.capacitySpecification(), other.capacitySpecification()) && Objects.equals(this.encryptionSpecification(), other.encryptionSpecification()) && Objects.equals(this.pointInTimeRecovery(), other.pointInTimeRecovery()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.defaultTimeToLive(), other.defaultTimeToLive());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTableRequest").add("KeyspaceName", (Object)this.keyspaceName()).add("TableName", (Object)this.tableName()).add("AddColumns", this.hasAddColumns() ? this.addColumns() : null).add("CapacitySpecification", (Object)this.capacitySpecification()).add("EncryptionSpecification", (Object)this.encryptionSpecification()).add("PointInTimeRecovery", (Object)this.pointInTimeRecovery()).add("Ttl", (Object)this.ttl()).add("DefaultTimeToLive", (Object)this.defaultTimeToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "addColumns": {
                return Optional.ofNullable(clazz.cast(this.addColumns()));
            }
            case "capacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.capacitySpecification()));
            }
            case "encryptionSpecification": {
                return Optional.ofNullable(clazz.cast(this.encryptionSpecification()));
            }
            case "pointInTimeRecovery": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeRecovery()));
            }
            case "ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "defaultTimeToLive": {
                return Optional.ofNullable(clazz.cast(this.defaultTimeToLive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesRequest.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String tableName;
        private List<ColumnDefinition> addColumns = DefaultSdkAutoConstructList.getInstance();
        private CapacitySpecification capacitySpecification;
        private EncryptionSpecification encryptionSpecification;
        private PointInTimeRecovery pointInTimeRecovery;
        private TimeToLive ttl;
        private Integer defaultTimeToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.tableName(model.tableName);
            this.addColumns(model.addColumns);
            this.capacitySpecification(model.capacitySpecification);
            this.encryptionSpecification(model.encryptionSpecification);
            this.pointInTimeRecovery(model.pointInTimeRecovery);
            this.ttl(model.ttl);
            this.defaultTimeToLive(model.defaultTimeToLive);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<ColumnDefinition.Builder> getAddColumns() {
            List<ColumnDefinition.Builder> result = ColumnDefinitionListCopier.copyToBuilder(this.addColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddColumns(Collection<ColumnDefinition.BuilderImpl> addColumns) {
            this.addColumns = ColumnDefinitionListCopier.copyFromBuilder(addColumns);
        }

        @Override
        public final Builder addColumns(Collection<ColumnDefinition> addColumns) {
            this.addColumns = ColumnDefinitionListCopier.copy(addColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addColumns(ColumnDefinition ... addColumns) {
            this.addColumns(Arrays.asList(addColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addColumns(Consumer<ColumnDefinition.Builder> ... addColumns) {
            this.addColumns(Stream.of(addColumns).map(c -> (ColumnDefinition)((ColumnDefinition.Builder)ColumnDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CapacitySpecification.Builder getCapacitySpecification() {
            return this.capacitySpecification != null ? this.capacitySpecification.toBuilder() : null;
        }

        public final void setCapacitySpecification(CapacitySpecification.BuilderImpl capacitySpecification) {
            this.capacitySpecification = capacitySpecification != null ? capacitySpecification.build() : null;
        }

        @Override
        public final Builder capacitySpecification(CapacitySpecification capacitySpecification) {
            this.capacitySpecification = capacitySpecification;
            return this;
        }

        public final EncryptionSpecification.Builder getEncryptionSpecification() {
            return this.encryptionSpecification != null ? this.encryptionSpecification.toBuilder() : null;
        }

        public final void setEncryptionSpecification(EncryptionSpecification.BuilderImpl encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification != null ? encryptionSpecification.build() : null;
        }

        @Override
        public final Builder encryptionSpecification(EncryptionSpecification encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification;
            return this;
        }

        public final PointInTimeRecovery.Builder getPointInTimeRecovery() {
            return this.pointInTimeRecovery != null ? this.pointInTimeRecovery.toBuilder() : null;
        }

        public final void setPointInTimeRecovery(PointInTimeRecovery.BuilderImpl pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery != null ? pointInTimeRecovery.build() : null;
        }

        @Override
        public final Builder pointInTimeRecovery(PointInTimeRecovery pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public final TimeToLive.Builder getTtl() {
            return this.ttl != null ? this.ttl.toBuilder() : null;
        }

        public final void setTtl(TimeToLive.BuilderImpl ttl) {
            this.ttl = ttl != null ? ttl.build() : null;
        }

        @Override
        public final Builder ttl(TimeToLive ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Integer getDefaultTimeToLive() {
            return this.defaultTimeToLive;
        }

        public final void setDefaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
        }

        @Override
        public final Builder defaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KeyspacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTableRequest> {
        public Builder keyspaceName(String var1);

        public Builder tableName(String var1);

        public Builder addColumns(Collection<ColumnDefinition> var1);

        public Builder addColumns(ColumnDefinition ... var1);

        public Builder addColumns(Consumer<ColumnDefinition.Builder> ... var1);

        public Builder capacitySpecification(CapacitySpecification var1);

        default public Builder capacitySpecification(Consumer<CapacitySpecification.Builder> capacitySpecification) {
            return this.capacitySpecification((CapacitySpecification)((CapacitySpecification.Builder)CapacitySpecification.builder().applyMutation(capacitySpecification)).build());
        }

        public Builder encryptionSpecification(EncryptionSpecification var1);

        default public Builder encryptionSpecification(Consumer<EncryptionSpecification.Builder> encryptionSpecification) {
            return this.encryptionSpecification((EncryptionSpecification)((EncryptionSpecification.Builder)EncryptionSpecification.builder().applyMutation(encryptionSpecification)).build());
        }

        public Builder pointInTimeRecovery(PointInTimeRecovery var1);

        default public Builder pointInTimeRecovery(Consumer<PointInTimeRecovery.Builder> pointInTimeRecovery) {
            return this.pointInTimeRecovery((PointInTimeRecovery)((PointInTimeRecovery.Builder)PointInTimeRecovery.builder().applyMutation(pointInTimeRecovery)).build());
        }

        public Builder ttl(TimeToLive var1);

        default public Builder ttl(Consumer<TimeToLive.Builder> ttl) {
            return this.ttl((TimeToLive)((TimeToLive.Builder)TimeToLive.builder().applyMutation(ttl)).build());
        }

        public Builder defaultTimeToLive(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

