/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ThrottleReason {
    CONCURRENT_INVOCATION_LIMIT_EXCEEDED("ConcurrentInvocationLimitExceeded"),
    FUNCTION_INVOCATION_RATE_LIMIT_EXCEEDED("FunctionInvocationRateLimitExceeded"),
    RESERVED_FUNCTION_CONCURRENT_INVOCATION_LIMIT_EXCEEDED("ReservedFunctionConcurrentInvocationLimitExceeded"),
    RESERVED_FUNCTION_INVOCATION_RATE_LIMIT_EXCEEDED("ReservedFunctionInvocationRateLimitExceeded"),
    CALLER_RATE_LIMIT_EXCEEDED("CallerRateLimitExceeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThrottleReason> VALUE_MAP;
    private final String value;

    private ThrottleReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThrottleReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThrottleReason> knownValues() {
        EnumSet<ThrottleReason> knownValues = EnumSet.allOf(ThrottleReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ThrottleReason.class, ThrottleReason::toString);
    }
}

