/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.ResponseSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntentConfirmationSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntentConfirmationSetting> {
    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptSpecification").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::promptSpecification)).setter(IntentConfirmationSetting.setter(Builder::promptSpecification)).constructor(PromptSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build()}).build();
    private static final SdkField<ResponseSpecification> DECLINATION_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("declinationResponse").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::declinationResponse)).setter(IntentConfirmationSetting.setter(Builder::declinationResponse)).constructor(ResponseSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationResponse").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(IntentConfirmationSetting.getter(IntentConfirmationSetting::active)).setter(IntentConfirmationSetting.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_SPECIFICATION_FIELD, DECLINATION_RESPONSE_FIELD, ACTIVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final PromptSpecification promptSpecification;
    private final ResponseSpecification declinationResponse;
    private final Boolean active;

    private IntentConfirmationSetting(BuilderImpl builder) {
        this.promptSpecification = builder.promptSpecification;
        this.declinationResponse = builder.declinationResponse;
        this.active = builder.active;
    }

    public final PromptSpecification promptSpecification() {
        return this.promptSpecification;
    }

    public final ResponseSpecification declinationResponse() {
        return this.declinationResponse;
    }

    public final Boolean active() {
        return this.active;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.declinationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentConfirmationSetting)) {
            return false;
        }
        IntentConfirmationSetting other = (IntentConfirmationSetting)obj;
        return Objects.equals(this.promptSpecification(), other.promptSpecification()) && Objects.equals(this.declinationResponse(), other.declinationResponse()) && Objects.equals(this.active(), other.active());
    }

    public final String toString() {
        return ToString.builder((String)"IntentConfirmationSetting").add("PromptSpecification", (Object)this.promptSpecification()).add("DeclinationResponse", (Object)this.declinationResponse()).add("Active", (Object)this.active()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptSpecification": {
                return Optional.ofNullable(clazz.cast(this.promptSpecification()));
            }
            case "declinationResponse": {
                return Optional.ofNullable(clazz.cast(this.declinationResponse()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentConfirmationSetting, T> g) {
        return obj -> g.apply((IntentConfirmationSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PromptSpecification promptSpecification;
        private ResponseSpecification declinationResponse;
        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentConfirmationSetting model) {
            this.promptSpecification(model.promptSpecification);
            this.declinationResponse(model.declinationResponse);
            this.active(model.active);
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return this.promptSpecification != null ? this.promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final ResponseSpecification.Builder getDeclinationResponse() {
            return this.declinationResponse != null ? this.declinationResponse.toBuilder() : null;
        }

        public final void setDeclinationResponse(ResponseSpecification.BuilderImpl declinationResponse) {
            this.declinationResponse = declinationResponse != null ? declinationResponse.build() : null;
        }

        @Override
        public final Builder declinationResponse(ResponseSpecification declinationResponse) {
            this.declinationResponse = declinationResponse;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public IntentConfirmationSetting build() {
            return new IntentConfirmationSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntentConfirmationSetting> {
        public Builder promptSpecification(PromptSpecification var1);

        default public Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return this.promptSpecification((PromptSpecification)((PromptSpecification.Builder)PromptSpecification.builder().applyMutation(promptSpecification)).build());
        }

        public Builder declinationResponse(ResponseSpecification var1);

        default public Builder declinationResponse(Consumer<ResponseSpecification.Builder> declinationResponse) {
            return this.declinationResponse((ResponseSpecification)((ResponseSpecification.Builder)ResponseSpecification.builder().applyMutation(declinationResponse)).build());
        }

        public Builder active(Boolean var1);
    }
}

