/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup;
import software.amazon.awssdk.services.lexmodelsv2.model.MessageGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PromptSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PromptSpecification> {
    private static final SdkField<List<MessageGroup>> MESSAGE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messageGroups").getter(PromptSpecification.getter(PromptSpecification::messageGroups)).setter(PromptSpecification.setter(Builder::messageGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxRetries").getter(PromptSpecification.getter(PromptSpecification::maxRetries)).setter(PromptSpecification.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetries").build()}).build();
    private static final SdkField<Boolean> ALLOW_INTERRUPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowInterrupt").getter(PromptSpecification.getter(PromptSpecification::allowInterrupt)).setter(PromptSpecification.setter(Builder::allowInterrupt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowInterrupt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_GROUPS_FIELD, MAX_RETRIES_FIELD, ALLOW_INTERRUPT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<MessageGroup> messageGroups;
    private final Integer maxRetries;
    private final Boolean allowInterrupt;

    private PromptSpecification(BuilderImpl builder) {
        this.messageGroups = builder.messageGroups;
        this.maxRetries = builder.maxRetries;
        this.allowInterrupt = builder.allowInterrupt;
    }

    public final boolean hasMessageGroups() {
        return this.messageGroups != null && !(this.messageGroups instanceof SdkAutoConstructList);
    }

    public final List<MessageGroup> messageGroups() {
        return this.messageGroups;
    }

    public final Integer maxRetries() {
        return this.maxRetries;
    }

    public final Boolean allowInterrupt() {
        return this.allowInterrupt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageGroups() ? this.messageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowInterrupt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptSpecification)) {
            return false;
        }
        PromptSpecification other = (PromptSpecification)obj;
        return this.hasMessageGroups() == other.hasMessageGroups() && Objects.equals(this.messageGroups(), other.messageGroups()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.allowInterrupt(), other.allowInterrupt());
    }

    public final String toString() {
        return ToString.builder((String)"PromptSpecification").add("MessageGroups", this.hasMessageGroups() ? this.messageGroups() : null).add("MaxRetries", (Object)this.maxRetries()).add("AllowInterrupt", (Object)this.allowInterrupt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageGroups": {
                return Optional.ofNullable(clazz.cast(this.messageGroups()));
            }
            case "maxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "allowInterrupt": {
                return Optional.ofNullable(clazz.cast(this.allowInterrupt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptSpecification, T> g) {
        return obj -> g.apply((PromptSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MessageGroup> messageGroups = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRetries;
        private Boolean allowInterrupt;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptSpecification model) {
            this.messageGroups(model.messageGroups);
            this.maxRetries(model.maxRetries);
            this.allowInterrupt(model.allowInterrupt);
        }

        public final List<MessageGroup.Builder> getMessageGroups() {
            List<MessageGroup.Builder> result = MessageGroupsListCopier.copyToBuilder(this.messageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageGroups(Collection<MessageGroup.BuilderImpl> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copyFromBuilder(messageGroups);
        }

        @Override
        public final Builder messageGroups(Collection<MessageGroup> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copy(messageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(MessageGroup ... messageGroups) {
            this.messageGroups(Arrays.asList(messageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(Consumer<MessageGroup.Builder> ... messageGroups) {
            this.messageGroups(Stream.of(messageGroups).map(c -> (MessageGroup)((MessageGroup.Builder)MessageGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final Boolean getAllowInterrupt() {
            return this.allowInterrupt;
        }

        public final void setAllowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
        }

        @Override
        public final Builder allowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
            return this;
        }

        public PromptSpecification build() {
            return new PromptSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PromptSpecification> {
        public Builder messageGroups(Collection<MessageGroup> var1);

        public Builder messageGroups(MessageGroup ... var1);

        public Builder messageGroups(Consumer<MessageGroup.Builder> ... var1);

        public Builder maxRetries(Integer var1);

        public Builder allowInterrupt(Boolean var1);
    }
}

