/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMapSpritesRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, GetMapSpritesRequest> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(GetMapSpritesRequest.getter(GetMapSpritesRequest::fileName)).setter(GetMapSpritesRequest.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileName").build()}).build();
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(GetMapSpritesRequest.getter(GetMapSpritesRequest::mapName)).setter(GetMapSpritesRequest.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD, MAP_NAME_FIELD));
    private final String fileName;
    private final String mapName;

    private GetMapSpritesRequest(BuilderImpl builder) {
        super(builder);
        this.fileName = builder.fileName;
        this.mapName = builder.mapName;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final String mapName() {
        return this.mapName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapSpritesRequest)) {
            return false;
        }
        GetMapSpritesRequest other = (GetMapSpritesRequest)((Object)obj);
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.mapName(), other.mapName());
    }

    public final String toString() {
        return ToString.builder((String)"GetMapSpritesRequest").add("FileName", (Object)this.fileName()).add("MapName", (Object)this.mapName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMapSpritesRequest, T> g) {
        return obj -> g.apply((GetMapSpritesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String fileName;
        private String mapName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapSpritesRequest model) {
            super(model);
            this.fileName(model.fileName);
            this.mapName(model.mapName);
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getMapName() {
            return this.mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMapSpritesRequest build() {
            return new GetMapSpritesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMapSpritesRequest> {
        public Builder fileName(String var1);

        public Builder mapName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

