/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse;

public class ListSensorStatisticsPublisher
implements SdkPublisher<ListSensorStatisticsResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListSensorStatisticsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSensorStatisticsPublisher(LookoutEquipmentAsyncClient client, ListSensorStatisticsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSensorStatisticsPublisher(LookoutEquipmentAsyncClient client, ListSensorStatisticsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSensorStatisticsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSensorStatisticsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSensorStatisticsResponseFetcher
    implements AsyncPageFetcher<ListSensorStatisticsResponse> {
        private ListSensorStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(ListSensorStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSensorStatisticsResponse> nextPage(ListSensorStatisticsResponse previousPage) {
            if (previousPage == null) {
                return ListSensorStatisticsPublisher.this.client.listSensorStatistics(ListSensorStatisticsPublisher.this.firstRequest);
            }
            return ListSensorStatisticsPublisher.this.client.listSensorStatistics((ListSensorStatisticsRequest)((Object)ListSensorStatisticsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

