/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsAsyncClient;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse;

public class ListAnomalyDetectorsPublisher
implements SdkPublisher<ListAnomalyDetectorsResponse> {
    private final LookoutMetricsAsyncClient client;
    private final ListAnomalyDetectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnomalyDetectorsPublisher(LookoutMetricsAsyncClient client, ListAnomalyDetectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnomalyDetectorsPublisher(LookoutMetricsAsyncClient client, ListAnomalyDetectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnomalyDetectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnomalyDetectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAnomalyDetectorsResponseFetcher
    implements AsyncPageFetcher<ListAnomalyDetectorsResponse> {
        private ListAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnomalyDetectorsResponse> nextPage(ListAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalyDetectorsPublisher.this.client.listAnomalyDetectors(ListAnomalyDetectorsPublisher.this.firstRequest);
            }
            return ListAnomalyDetectorsPublisher.this.client.listAnomalyDetectors((ListAnomalyDetectorsRequest)((Object)ListAnomalyDetectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

