/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.EntitlementStatus;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateEncryption;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowEntitlementRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateFlowEntitlementRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateFlowEntitlementRequest.getter(UpdateFlowEntitlementRequest::description)).setter(UpdateFlowEntitlementRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<UpdateEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(UpdateFlowEntitlementRequest.getter(UpdateFlowEntitlementRequest::encryption)).setter(UpdateFlowEntitlementRequest.setter(Builder::encryption)).constructor(UpdateEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementArn").getter(UpdateFlowEntitlementRequest.getter(UpdateFlowEntitlementRequest::entitlementArn)).setter(UpdateFlowEntitlementRequest.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entitlementArn").build()}).build();
    private static final SdkField<String> ENTITLEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementStatus").getter(UpdateFlowEntitlementRequest.getter(UpdateFlowEntitlementRequest::entitlementStatusAsString)).setter(UpdateFlowEntitlementRequest.setter(Builder::entitlementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementStatus").build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateFlowEntitlementRequest.getter(UpdateFlowEntitlementRequest::flowArn)).setter(UpdateFlowEntitlementRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()}).build();
    private static final SdkField<List<String>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(UpdateFlowEntitlementRequest.getter(UpdateFlowEntitlementRequest::subscribers)).setter(UpdateFlowEntitlementRequest.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ENCRYPTION_FIELD, ENTITLEMENT_ARN_FIELD, ENTITLEMENT_STATUS_FIELD, FLOW_ARN_FIELD, SUBSCRIBERS_FIELD));
    private final String description;
    private final UpdateEncryption encryption;
    private final String entitlementArn;
    private final String entitlementStatus;
    private final String flowArn;
    private final List<String> subscribers;

    private UpdateFlowEntitlementRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.encryption = builder.encryption;
        this.entitlementArn = builder.entitlementArn;
        this.entitlementStatus = builder.entitlementStatus;
        this.flowArn = builder.flowArn;
        this.subscribers = builder.subscribers;
    }

    public final String description() {
        return this.description;
    }

    public final UpdateEncryption encryption() {
        return this.encryption;
    }

    public final String entitlementArn() {
        return this.entitlementArn;
    }

    public final EntitlementStatus entitlementStatus() {
        return EntitlementStatus.fromValue(this.entitlementStatus);
    }

    public final String entitlementStatusAsString() {
        return this.entitlementStatus;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public final List<String> subscribers() {
        return this.subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribers() ? this.subscribers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowEntitlementRequest)) {
            return false;
        }
        UpdateFlowEntitlementRequest other = (UpdateFlowEntitlementRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.entitlementStatusAsString(), other.entitlementStatusAsString()) && Objects.equals(this.flowArn(), other.flowArn()) && this.hasSubscribers() == other.hasSubscribers() && Objects.equals(this.subscribers(), other.subscribers());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowEntitlementRequest").add("Description", (Object)this.description()).add("Encryption", (Object)this.encryption()).add("EntitlementArn", (Object)this.entitlementArn()).add("EntitlementStatus", (Object)this.entitlementStatusAsString()).add("FlowArn", (Object)this.flowArn()).add("Subscribers", this.hasSubscribers() ? this.subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "EntitlementStatus": {
                return Optional.ofNullable(clazz.cast(this.entitlementStatusAsString()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowEntitlementRequest, T> g) {
        return obj -> g.apply((UpdateFlowEntitlementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String description;
        private UpdateEncryption encryption;
        private String entitlementArn;
        private String entitlementStatus;
        private String flowArn;
        private List<String> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowEntitlementRequest model) {
            super(model);
            this.description(model.description);
            this.encryption(model.encryption);
            this.entitlementArn(model.entitlementArn);
            this.entitlementStatus(model.entitlementStatus);
            this.flowArn(model.flowArn);
            this.subscribers(model.subscribers);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final UpdateEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(UpdateEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(UpdateEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getEntitlementStatus() {
            return this.entitlementStatus;
        }

        public final void setEntitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
        }

        @Override
        public final Builder entitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
            return this;
        }

        @Override
        public final Builder entitlementStatus(EntitlementStatus entitlementStatus) {
            this.entitlementStatus(entitlementStatus == null ? null : entitlementStatus.toString());
            return this;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final Collection<String> getSubscribers() {
            if (this.subscribers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subscribers;
        }

        public final void setSubscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
        }

        @Override
        public final Builder subscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(String ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowEntitlementRequest build() {
            return new UpdateFlowEntitlementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowEntitlementRequest> {
        public Builder description(String var1);

        public Builder encryption(UpdateEncryption var1);

        default public Builder encryption(Consumer<UpdateEncryption.Builder> encryption) {
            return this.encryption((UpdateEncryption)((UpdateEncryption.Builder)UpdateEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder entitlementArn(String var1);

        public Builder entitlementStatus(String var1);

        public Builder entitlementStatus(EntitlementStatus var1);

        public Builder flowArn(String var1);

        public Builder subscribers(Collection<String> var1);

        public Builder subscribers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

