/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaticKeySettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaticKeySettings> {
    private static final SdkField<InputLocation> KEY_PROVIDER_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyProviderServer").getter(StaticKeySettings.getter(StaticKeySettings::keyProviderServer)).setter(StaticKeySettings.setter(Builder::keyProviderServer)).constructor(InputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyProviderServer").build()}).build();
    private static final SdkField<String> STATIC_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StaticKeyValue").getter(StaticKeySettings.getter(StaticKeySettings::staticKeyValue)).setter(StaticKeySettings.setter(Builder::staticKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PROVIDER_SERVER_FIELD, STATIC_KEY_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final InputLocation keyProviderServer;
    private final String staticKeyValue;

    private StaticKeySettings(BuilderImpl builder) {
        this.keyProviderServer = builder.keyProviderServer;
        this.staticKeyValue = builder.staticKeyValue;
    }

    public final InputLocation keyProviderServer() {
        return this.keyProviderServer;
    }

    public final String staticKeyValue() {
        return this.staticKeyValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyProviderServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticKeyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticKeySettings)) {
            return false;
        }
        StaticKeySettings other = (StaticKeySettings)obj;
        return Objects.equals(this.keyProviderServer(), other.keyProviderServer()) && Objects.equals(this.staticKeyValue(), other.staticKeyValue());
    }

    public final String toString() {
        return ToString.builder((String)"StaticKeySettings").add("KeyProviderServer", (Object)this.keyProviderServer()).add("StaticKeyValue", (Object)this.staticKeyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyProviderServer": {
                return Optional.ofNullable(clazz.cast(this.keyProviderServer()));
            }
            case "StaticKeyValue": {
                return Optional.ofNullable(clazz.cast(this.staticKeyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaticKeySettings, T> g) {
        return obj -> g.apply((StaticKeySettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InputLocation keyProviderServer;
        private String staticKeyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticKeySettings model) {
            this.keyProviderServer(model.keyProviderServer);
            this.staticKeyValue(model.staticKeyValue);
        }

        public final InputLocation.Builder getKeyProviderServer() {
            return this.keyProviderServer != null ? this.keyProviderServer.toBuilder() : null;
        }

        public final void setKeyProviderServer(InputLocation.BuilderImpl keyProviderServer) {
            this.keyProviderServer = keyProviderServer != null ? keyProviderServer.build() : null;
        }

        @Override
        public final Builder keyProviderServer(InputLocation keyProviderServer) {
            this.keyProviderServer = keyProviderServer;
            return this;
        }

        public final String getStaticKeyValue() {
            return this.staticKeyValue;
        }

        public final void setStaticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
        }

        @Override
        public final Builder staticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
            return this;
        }

        public StaticKeySettings build() {
            return new StaticKeySettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaticKeySettings> {
        public Builder keyProviderServer(InputLocation var1);

        default public Builder keyProviderServer(Consumer<InputLocation.Builder> keyProviderServer) {
            return this.keyProviderServer((InputLocation)((InputLocation.Builder)InputLocation.builder().applyMutation(keyProviderServer)).build());
        }

        public Builder staticKeyValue(String var1);
    }
}

