/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodClient;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.PackagingConfiguration;

public class ListPackagingConfigurationsIterable
implements SdkIterable<ListPackagingConfigurationsResponse> {
    private final MediaPackageVodClient client;
    private final ListPackagingConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackagingConfigurationsIterable(MediaPackageVodClient client, ListPackagingConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPackagingConfigurationsResponseFetcher();
    }

    public Iterator<ListPackagingConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackagingConfiguration> packagingConfigurations() {
        Function<ListPackagingConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packagingConfigurations() != null) {
                return response.packagingConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackagingConfigurationsResponseFetcher
    implements SyncPageFetcher<ListPackagingConfigurationsResponse> {
        private ListPackagingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackagingConfigurationsResponse nextPage(ListPackagingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListPackagingConfigurationsIterable.this.client.listPackagingConfigurations(ListPackagingConfigurationsIterable.this.firstRequest);
            }
            return ListPackagingConfigurationsIterable.this.client.listPackagingConfigurations((ListPackagingConfigurationsRequest)((Object)ListPackagingConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

