/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.HttpMethod;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.HttpMethodsCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UriPathRouteInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UriPathRouteInput> {
    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationState").getter(UriPathRouteInput.getter(UriPathRouteInput::activationStateAsString)).setter(UriPathRouteInput.setter(Builder::activationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CHILD_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeChildPaths").getter(UriPathRouteInput.getter(UriPathRouteInput::includeChildPaths)).setter(UriPathRouteInput.setter(Builder::includeChildPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeChildPaths").build()}).build();
    private static final SdkField<List<String>> METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Methods").getter(UriPathRouteInput.getter(UriPathRouteInput::methodsAsStrings)).setter(UriPathRouteInput.setter(Builder::methodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Methods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePath").getter(UriPathRouteInput.getter(UriPathRouteInput::sourcePath)).setter(UriPathRouteInput.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_STATE_FIELD, INCLUDE_CHILD_PATHS_FIELD, METHODS_FIELD, SOURCE_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activationState;
    private final Boolean includeChildPaths;
    private final List<String> methods;
    private final String sourcePath;

    private UriPathRouteInput(BuilderImpl builder) {
        this.activationState = builder.activationState;
        this.includeChildPaths = builder.includeChildPaths;
        this.methods = builder.methods;
        this.sourcePath = builder.sourcePath;
    }

    public final RouteActivationState activationState() {
        return RouteActivationState.fromValue(this.activationState);
    }

    public final String activationStateAsString() {
        return this.activationState;
    }

    public final Boolean includeChildPaths() {
        return this.includeChildPaths;
    }

    public final List<HttpMethod> methods() {
        return HttpMethodsCopier.copyStringToEnum(this.methods);
    }

    public final boolean hasMethods() {
        return this.methods != null && !(this.methods instanceof SdkAutoConstructList);
    }

    public final List<String> methodsAsStrings() {
        return this.methods;
    }

    public final String sourcePath() {
        return this.sourcePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeChildPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMethods() ? this.methodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UriPathRouteInput)) {
            return false;
        }
        UriPathRouteInput other = (UriPathRouteInput)obj;
        return Objects.equals(this.activationStateAsString(), other.activationStateAsString()) && Objects.equals(this.includeChildPaths(), other.includeChildPaths()) && this.hasMethods() == other.hasMethods() && Objects.equals(this.methodsAsStrings(), other.methodsAsStrings()) && Objects.equals(this.sourcePath(), other.sourcePath());
    }

    public final String toString() {
        return ToString.builder((String)"UriPathRouteInput").add("ActivationState", (Object)this.activationStateAsString()).add("IncludeChildPaths", (Object)this.includeChildPaths()).add("Methods", this.hasMethods() ? this.methodsAsStrings() : null).add("SourcePath", (Object)this.sourcePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationState": {
                return Optional.ofNullable(clazz.cast(this.activationStateAsString()));
            }
            case "IncludeChildPaths": {
                return Optional.ofNullable(clazz.cast(this.includeChildPaths()));
            }
            case "Methods": {
                return Optional.ofNullable(clazz.cast(this.methodsAsStrings()));
            }
            case "SourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UriPathRouteInput, T> g) {
        return obj -> g.apply((UriPathRouteInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activationState;
        private Boolean includeChildPaths;
        private List<String> methods = DefaultSdkAutoConstructList.getInstance();
        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(UriPathRouteInput model) {
            this.activationState(model.activationState);
            this.includeChildPaths(model.includeChildPaths);
            this.methodsWithStrings(model.methods);
            this.sourcePath(model.sourcePath);
        }

        public final String getActivationState() {
            return this.activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(RouteActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final Boolean getIncludeChildPaths() {
            return this.includeChildPaths;
        }

        public final void setIncludeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
        }

        @Override
        public final Builder includeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
            return this;
        }

        public final Collection<String> getMethods() {
            if (this.methods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.methods;
        }

        public final void setMethods(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
        }

        @Override
        public final Builder methodsWithStrings(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methodsWithStrings(String ... methods) {
            this.methodsWithStrings(Arrays.asList(methods));
            return this;
        }

        @Override
        public final Builder methods(Collection<HttpMethod> methods) {
            this.methods = HttpMethodsCopier.copyEnumToString(methods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methods(HttpMethod ... methods) {
            this.methods(Arrays.asList(methods));
            return this;
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public UriPathRouteInput build() {
            return new UriPathRouteInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UriPathRouteInput> {
        public Builder activationState(String var1);

        public Builder activationState(RouteActivationState var1);

        public Builder includeChildPaths(Boolean var1);

        public Builder methodsWithStrings(Collection<String> var1);

        public Builder methodsWithStrings(String ... var1);

        public Builder methods(Collection<HttpMethod> var1);

        public Builder methods(HttpMethod ... var1);

        public Builder sourcePath(String var1);
    }
}

