/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyClient;
import software.amazon.awssdk.services.migrationhubstrategy.model.Collector;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse;

public class ListCollectorsIterable
implements SdkIterable<ListCollectorsResponse> {
    private final MigrationHubStrategyClient client;
    private final ListCollectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollectorsIterable(MigrationHubStrategyClient client, ListCollectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCollectorsResponseFetcher();
    }

    public Iterator<ListCollectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Collector> collectors() {
        Function<ListCollectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collectors() != null) {
                return response.collectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollectorsResponseFetcher
    implements SyncPageFetcher<ListCollectorsResponse> {
        private ListCollectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollectorsResponse nextPage(ListCollectorsResponse previousPage) {
            if (previousPage == null) {
                return ListCollectorsIterable.this.client.listCollectors(ListCollectorsIterable.this.firstRequest);
            }
            return ListCollectorsIterable.this.client.listCollectors((ListCollectorsRequest)((Object)ListCollectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

