/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.Device;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse;

public class GetDevicesIterable
implements SdkIterable<GetDevicesResponse> {
    private final NetworkManagerClient client;
    private final GetDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDevicesIterable(NetworkManagerClient client, GetDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDevicesResponseFetcher();
    }

    public Iterator<GetDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Device> devices() {
        Function<GetDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetDevicesResponseFetcher
    implements SyncPageFetcher<GetDevicesResponse> {
        private GetDevicesResponseFetcher() {
        }

        public boolean hasNextPage(GetDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDevicesResponse nextPage(GetDevicesResponse previousPage) {
            if (previousPage == null) {
                return GetDevicesIterable.this.client.getDevices(GetDevicesIterable.this.firstRequest);
            }
            return GetDevicesIterable.this.client.getDevices((GetDevicesRequest)((Object)GetDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

