/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse;

public class ListConnectPeersIterable
implements SdkIterable<ListConnectPeersResponse> {
    private final NetworkManagerClient client;
    private final ListConnectPeersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectPeersIterable(NetworkManagerClient client, ListConnectPeersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListConnectPeersResponseFetcher();
    }

    public Iterator<ListConnectPeersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectPeerSummary> connectPeers() {
        Function<ListConnectPeersResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectPeers() != null) {
                return response.connectPeers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectPeersResponseFetcher
    implements SyncPageFetcher<ListConnectPeersResponse> {
        private ListConnectPeersResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectPeersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectPeersResponse nextPage(ListConnectPeersResponse previousPage) {
            if (previousPage == null) {
                return ListConnectPeersIterable.this.client.listConnectPeers(ListConnectPeersIterable.this.firstRequest);
            }
            return ListConnectPeersIterable.this.client.listConnectPeers((ListConnectPeersRequest)((Object)ListConnectPeersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

