/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;

public class ListChildrenPublisher
implements SdkPublisher<ListChildrenResponse> {
    private final OrganizationsAsyncClient client;
    private final ListChildrenRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChildrenPublisher(OrganizationsAsyncClient client, ListChildrenRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChildrenPublisher(OrganizationsAsyncClient client, ListChildrenRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChildrenResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChildrenResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChildrenResponseFetcher
    implements AsyncPageFetcher<ListChildrenResponse> {
        private ListChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListChildrenResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChildrenResponse> nextPage(ListChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListChildrenPublisher.this.client.listChildren(ListChildrenPublisher.this.firstRequest);
            }
            return ListChildrenPublisher.this.client.listChildren((ListChildrenRequest)((Object)ListChildrenPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

