/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedResource> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(ProvisionedResource.getter(ProvisionedResource::identifier)).setter(ProvisionedResource.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ProvisionedResource.getter(ProvisionedResource::name)).setter(ProvisionedResource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVISIONING_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioningEngine").getter(ProvisionedResource.getter(ProvisionedResource::provisioningEngineAsString)).setter(ProvisionedResource.setter(Builder::provisioningEngine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningEngine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, NAME_FIELD, PROVISIONING_ENGINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String name;
    private final String provisioningEngine;

    private ProvisionedResource(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.provisioningEngine = builder.provisioningEngine;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final ProvisionedResourceEngine provisioningEngine() {
        return ProvisionedResourceEngine.fromValue(this.provisioningEngine);
    }

    public final String provisioningEngineAsString() {
        return this.provisioningEngine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningEngineAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedResource)) {
            return false;
        }
        ProvisionedResource other = (ProvisionedResource)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provisioningEngineAsString(), other.provisioningEngineAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedResource").add("Identifier", (Object)this.identifier()).add("Name", (Object)this.name()).add("ProvisioningEngine", (Object)this.provisioningEngineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provisioningEngine": {
                return Optional.ofNullable(clazz.cast(this.provisioningEngineAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedResource, T> g) {
        return obj -> g.apply((ProvisionedResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String name;
        private String provisioningEngine;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedResource model) {
            this.identifier(model.identifier);
            this.name(model.name);
            this.provisioningEngine(model.provisioningEngine);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioningEngine() {
            return this.provisioningEngine;
        }

        public final void setProvisioningEngine(String provisioningEngine) {
            this.provisioningEngine = provisioningEngine;
        }

        @Override
        public final Builder provisioningEngine(String provisioningEngine) {
            this.provisioningEngine = provisioningEngine;
            return this;
        }

        @Override
        public final Builder provisioningEngine(ProvisionedResourceEngine provisioningEngine) {
            this.provisioningEngine(provisioningEngine == null ? null : provisioningEngine.toString());
            return this;
        }

        public ProvisionedResource build() {
            return new ProvisionedResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedResource> {
        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder provisioningEngine(String var1);

        public Builder provisioningEngine(ProvisionedResourceEngine var1);
    }
}

