/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse;
import software.amazon.awssdk.services.proton.model.RepositorySyncDefinition;

public class ListRepositorySyncDefinitionsIterable
implements SdkIterable<ListRepositorySyncDefinitionsResponse> {
    private final ProtonClient client;
    private final ListRepositorySyncDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRepositorySyncDefinitionsIterable(ProtonClient client, ListRepositorySyncDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRepositorySyncDefinitionsResponseFetcher();
    }

    public Iterator<ListRepositorySyncDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RepositorySyncDefinition> syncDefinitions() {
        Function<ListRepositorySyncDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.syncDefinitions() != null) {
                return response.syncDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRepositorySyncDefinitionsResponseFetcher
    implements SyncPageFetcher<ListRepositorySyncDefinitionsResponse> {
        private ListRepositorySyncDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositorySyncDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRepositorySyncDefinitionsResponse nextPage(ListRepositorySyncDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListRepositorySyncDefinitionsIterable.this.client.listRepositorySyncDefinitions(ListRepositorySyncDefinitionsIterable.this.firstRequest);
            }
            return ListRepositorySyncDefinitionsIterable.this.client.listRepositorySyncDefinitions((ListRepositorySyncDefinitionsRequest)((Object)ListRepositorySyncDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

