/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FolderType;
import software.amazon.awssdk.services.quicksight.model.PathCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Folder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Folder> {
    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FolderId").getter(Folder.getter(Folder::folderId)).setter(Folder.setter(Builder::folderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Folder.getter(Folder::arn)).setter(Folder.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Folder.getter(Folder::name)).setter(Folder.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FOLDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FolderType").getter(Folder.getter(Folder::folderTypeAsString)).setter(Folder.setter(Builder::folderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderType").build()}).build();
    private static final SdkField<List<String>> FOLDER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderPath").getter(Folder.getter(Folder::folderPath)).setter(Folder.setter(Builder::folderPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Folder.getter(Folder::createdTime)).setter(Folder.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Folder.getter(Folder::lastUpdatedTime)).setter(Folder.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDER_ID_FIELD, ARN_FIELD, NAME_FIELD, FOLDER_TYPE_FIELD, FOLDER_PATH_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String folderId;
    private final String arn;
    private final String name;
    private final String folderType;
    private final List<String> folderPath;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private Folder(BuilderImpl builder) {
        this.folderId = builder.folderId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.folderType = builder.folderType;
        this.folderPath = builder.folderPath;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String folderId() {
        return this.folderId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final FolderType folderType() {
        return FolderType.fromValue(this.folderType);
    }

    public final String folderTypeAsString() {
        return this.folderType;
    }

    public final boolean hasFolderPath() {
        return this.folderPath != null && !(this.folderPath instanceof SdkAutoConstructList);
    }

    public final List<String> folderPath() {
        return this.folderPath;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderPath() ? this.folderPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Folder)) {
            return false;
        }
        Folder other = (Folder)obj;
        return Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.folderTypeAsString(), other.folderTypeAsString()) && this.hasFolderPath() == other.hasFolderPath() && Objects.equals(this.folderPath(), other.folderPath()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"Folder").add("FolderId", (Object)this.folderId()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("FolderType", (Object)this.folderTypeAsString()).add("FolderPath", this.hasFolderPath() ? this.folderPath() : null).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FolderId": {
                return Optional.ofNullable(clazz.cast(this.folderId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FolderType": {
                return Optional.ofNullable(clazz.cast(this.folderTypeAsString()));
            }
            case "FolderPath": {
                return Optional.ofNullable(clazz.cast(this.folderPath()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Folder, T> g) {
        return obj -> g.apply((Folder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String folderId;
        private String arn;
        private String name;
        private String folderType;
        private List<String> folderPath = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Folder model) {
            this.folderId(model.folderId);
            this.arn(model.arn);
            this.name(model.name);
            this.folderType(model.folderType);
            this.folderPath(model.folderPath);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getFolderId() {
            return this.folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFolderType() {
            return this.folderType;
        }

        public final void setFolderType(String folderType) {
            this.folderType = folderType;
        }

        @Override
        public final Builder folderType(String folderType) {
            this.folderType = folderType;
            return this;
        }

        @Override
        public final Builder folderType(FolderType folderType) {
            this.folderType(folderType == null ? null : folderType.toString());
            return this;
        }

        public final Collection<String> getFolderPath() {
            if (this.folderPath instanceof SdkAutoConstructList) {
                return null;
            }
            return this.folderPath;
        }

        public final void setFolderPath(Collection<String> folderPath) {
            this.folderPath = PathCopier.copy(folderPath);
        }

        @Override
        public final Builder folderPath(Collection<String> folderPath) {
            this.folderPath = PathCopier.copy(folderPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderPath(String ... folderPath) {
            this.folderPath(Arrays.asList(folderPath));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public Folder build() {
            return new Folder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Folder> {
        public Builder folderId(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder folderType(String var1);

        public Builder folderType(FolderType var1);

        public Builder folderPath(Collection<String> var1);

        public Builder folderPath(String ... var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

