/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus;

public class DescribeReservedNodeExchangeStatusPublisher
implements SdkPublisher<DescribeReservedNodeExchangeStatusResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeReservedNodeExchangeStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedNodeExchangeStatusPublisher(RedshiftAsyncClient client, DescribeReservedNodeExchangeStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedNodeExchangeStatusPublisher(RedshiftAsyncClient client, DescribeReservedNodeExchangeStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedNodeExchangeStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedNodeExchangeStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails() {
        Function<DescribeReservedNodeExchangeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeExchangeStatusDetails() != null) {
                return response.reservedNodeExchangeStatusDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedNodeExchangeStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReservedNodeExchangeStatusResponseFetcher
    implements AsyncPageFetcher<DescribeReservedNodeExchangeStatusResponse> {
        private DescribeReservedNodeExchangeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodeExchangeStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReservedNodeExchangeStatusResponse> nextPage(DescribeReservedNodeExchangeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodeExchangeStatusPublisher.this.client.describeReservedNodeExchangeStatus(DescribeReservedNodeExchangeStatusPublisher.this.firstRequest);
            }
            return DescribeReservedNodeExchangeStatusPublisher.this.client.describeReservedNodeExchangeStatus((DescribeReservedNodeExchangeStatusRequest)((Object)DescribeReservedNodeExchangeStatusPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

