/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse;

public class ListRecommendationTemplatesIterable
implements SdkIterable<ListRecommendationTemplatesResponse> {
    private final ResiliencehubClient client;
    private final ListRecommendationTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendationTemplatesIterable(ResiliencehubClient client, ListRecommendationTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecommendationTemplatesResponseFetcher();
    }

    public Iterator<ListRecommendationTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRecommendationTemplatesResponseFetcher
    implements SyncPageFetcher<ListRecommendationTemplatesResponse> {
        private ListRecommendationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendationTemplatesResponse nextPage(ListRecommendationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationTemplatesIterable.this.client.listRecommendationTemplates(ListRecommendationTemplatesIterable.this.firstRequest);
            }
            return ListRecommendationTemplatesIterable.this.client.listRecommendationTemplates((ListRecommendationTemplatesRequest)((Object)ListRecommendationTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

