/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.Group;
import software.amazon.awssdk.services.resourcegroups.model.GroupIdentifier;
import software.amazon.awssdk.services.resourcegroups.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.resourcegroups.model.GroupListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupsResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, ListGroupsResponse> {
    private static final SdkField<List<GroupIdentifier>> GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupIdentifiers").getter(ListGroupsResponse.getter(ListGroupsResponse::groupIdentifiers)).setter(ListGroupsResponse.setter(Builder::groupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Group>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(ListGroupsResponse.getter(ListGroupsResponse::groups)).setter(ListGroupsResponse.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupsResponse.getter(ListGroupsResponse::nextToken)).setter(ListGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IDENTIFIERS_FIELD, GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GroupIdentifier> groupIdentifiers;
    private final List<Group> groups;
    private final String nextToken;

    private ListGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.groupIdentifiers = builder.groupIdentifiers;
        this.groups = builder.groups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGroupIdentifiers() {
        return this.groupIdentifiers != null && !(this.groupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<GroupIdentifier> groupIdentifiers() {
        return this.groupIdentifiers;
    }

    @Deprecated
    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<Group> groups() {
        return this.groups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupIdentifiers() ? this.groupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsResponse)) {
            return false;
        }
        ListGroupsResponse other = (ListGroupsResponse)((Object)obj);
        return this.hasGroupIdentifiers() == other.hasGroupIdentifiers() && Objects.equals(this.groupIdentifiers(), other.groupIdentifiers()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupsResponse").add("GroupIdentifiers", this.hasGroupIdentifiers() ? this.groupIdentifiers() : null).add("Groups", this.hasGroups() ? this.groups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.groupIdentifiers()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsResponse, T> g) {
        return obj -> g.apply((ListGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private List<GroupIdentifier> groupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<Group> groups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsResponse model) {
            super(model);
            this.groupIdentifiers(model.groupIdentifiers);
            this.groups(model.groups);
            this.nextToken(model.nextToken);
        }

        public final List<GroupIdentifier.Builder> getGroupIdentifiers() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.groupIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupIdentifiers(Collection<GroupIdentifier.BuilderImpl> groupIdentifiers) {
            this.groupIdentifiers = GroupIdentifierListCopier.copyFromBuilder(groupIdentifiers);
        }

        @Override
        public final Builder groupIdentifiers(Collection<GroupIdentifier> groupIdentifiers) {
            this.groupIdentifiers = GroupIdentifierListCopier.copy(groupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIdentifiers(GroupIdentifier ... groupIdentifiers) {
            this.groupIdentifiers(Arrays.asList(groupIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIdentifiers(Consumer<GroupIdentifier.Builder> ... groupIdentifiers) {
            this.groupIdentifiers(Stream.of(groupIdentifiers).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<Group.Builder> getGroups() {
            List<Group.Builder> result = GroupListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setGroups(Collection<Group.BuilderImpl> groups) {
            this.groups = GroupListCopier.copyFromBuilder(groups);
        }

        @Override
        @Deprecated
        public final Builder groups(Collection<Group> groups) {
            this.groups = GroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder groups(Group ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder groups(Consumer<Group.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (Group)((Group.Builder)Group.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupsResponse build() {
            return new ListGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupsResponse> {
        public Builder groupIdentifiers(Collection<GroupIdentifier> var1);

        public Builder groupIdentifiers(GroupIdentifier ... var1);

        public Builder groupIdentifiers(Consumer<GroupIdentifier.Builder> ... var1);

        @Deprecated
        public Builder groups(Collection<Group> var1);

        @Deprecated
        public Builder groups(Group ... var1);

        @Deprecated
        public Builder groups(Consumer<Group.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

