/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsClient;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse;

public class SearchResourcesIterable
implements SdkIterable<SearchResourcesResponse> {
    private final ResourceGroupsClient client;
    private final SearchResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchResourcesIterable(ResourceGroupsClient client, SearchResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchResourcesResponseFetcher();
    }

    public Iterator<SearchResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceIdentifier> resourceIdentifiers() {
        Function<SearchResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceIdentifiers() != null) {
                return response.resourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchResourcesResponseFetcher
    implements SyncPageFetcher<SearchResourcesResponse> {
        private SearchResourcesResponseFetcher() {
        }

        public boolean hasNextPage(SearchResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchResourcesResponse nextPage(SearchResourcesResponse previousPage) {
            if (previousPage == null) {
                return SearchResourcesIterable.this.client.searchResources(SearchResourcesIterable.this.firstRequest);
            }
            return SearchResourcesIterable.this.client.searchResources((SearchResourcesRequest)((Object)SearchResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

