/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMapping;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesResponse
extends ResourceGroupsTaggingApiResponse
implements ToCopyableBuilder<Builder, GetResourcesResponse> {
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(GetResourcesResponse.getter(GetResourcesResponse::paginationToken)).setter(GetResourcesResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final SdkField<List<ResourceTagMapping>> RESOURCE_TAG_MAPPING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTagMappingList").getter(GetResourcesResponse.getter(GetResourcesResponse::resourceTagMappingList)).setter(GetResourcesResponse.setter(Builder::resourceTagMappingList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagMappingList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTagMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGINATION_TOKEN_FIELD, RESOURCE_TAG_MAPPING_LIST_FIELD));
    private final String paginationToken;
    private final List<ResourceTagMapping> resourceTagMappingList;

    private GetResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.paginationToken = builder.paginationToken;
        this.resourceTagMappingList = builder.resourceTagMappingList;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public final boolean hasResourceTagMappingList() {
        return this.resourceTagMappingList != null && !(this.resourceTagMappingList instanceof SdkAutoConstructList);
    }

    public final List<ResourceTagMapping> resourceTagMappingList() {
        return this.resourceTagMappingList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTagMappingList() ? this.resourceTagMappingList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesResponse)) {
            return false;
        }
        GetResourcesResponse other = (GetResourcesResponse)((Object)obj);
        return Objects.equals(this.paginationToken(), other.paginationToken()) && this.hasResourceTagMappingList() == other.hasResourceTagMappingList() && Objects.equals(this.resourceTagMappingList(), other.resourceTagMappingList());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcesResponse").add("PaginationToken", (Object)this.paginationToken()).add("ResourceTagMappingList", this.hasResourceTagMappingList() ? this.resourceTagMappingList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "ResourceTagMappingList": {
                return Optional.ofNullable(clazz.cast(this.resourceTagMappingList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesResponse, T> g) {
        return obj -> g.apply((GetResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiResponse.BuilderImpl
    implements Builder {
        private String paginationToken;
        private List<ResourceTagMapping> resourceTagMappingList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesResponse model) {
            super(model);
            this.paginationToken(model.paginationToken);
            this.resourceTagMappingList(model.resourceTagMappingList);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final List<ResourceTagMapping.Builder> getResourceTagMappingList() {
            List<ResourceTagMapping.Builder> result = ResourceTagMappingListCopier.copyToBuilder(this.resourceTagMappingList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTagMappingList(Collection<ResourceTagMapping.BuilderImpl> resourceTagMappingList) {
            this.resourceTagMappingList = ResourceTagMappingListCopier.copyFromBuilder(resourceTagMappingList);
        }

        @Override
        public final Builder resourceTagMappingList(Collection<ResourceTagMapping> resourceTagMappingList) {
            this.resourceTagMappingList = ResourceTagMappingListCopier.copy(resourceTagMappingList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagMappingList(ResourceTagMapping ... resourceTagMappingList) {
            this.resourceTagMappingList(Arrays.asList(resourceTagMappingList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagMappingList(Consumer<ResourceTagMapping.Builder> ... resourceTagMappingList) {
            this.resourceTagMappingList(Stream.of(resourceTagMappingList).map(c -> (ResourceTagMapping)((ResourceTagMapping.Builder)ResourceTagMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourcesResponse build() {
            return new GetResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesResponse> {
        public Builder paginationToken(String var1);

        public Builder resourceTagMappingList(Collection<ResourceTagMapping> var1);

        public Builder resourceTagMappingList(ResourceTagMapping ... var1);

        public Builder resourceTagMappingList(Consumer<ResourceTagMapping.Builder> ... var1);
    }
}

