/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagValuesOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTagValuesResponse
extends ResourceGroupsTaggingApiResponse
implements ToCopyableBuilder<Builder, GetTagValuesResponse> {
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(GetTagValuesResponse.getter(GetTagValuesResponse::paginationToken)).setter(GetTagValuesResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagValues").getter(GetTagValuesResponse.getter(GetTagValuesResponse::tagValues)).setter(GetTagValuesResponse.setter(Builder::tagValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGINATION_TOKEN_FIELD, TAG_VALUES_FIELD));
    private final String paginationToken;
    private final List<String> tagValues;

    private GetTagValuesResponse(BuilderImpl builder) {
        super(builder);
        this.paginationToken = builder.paginationToken;
        this.tagValues = builder.tagValues;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public final boolean hasTagValues() {
        return this.tagValues != null && !(this.tagValues instanceof SdkAutoConstructList);
    }

    public final List<String> tagValues() {
        return this.tagValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagValues() ? this.tagValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagValuesResponse)) {
            return false;
        }
        GetTagValuesResponse other = (GetTagValuesResponse)((Object)obj);
        return Objects.equals(this.paginationToken(), other.paginationToken()) && this.hasTagValues() == other.hasTagValues() && Objects.equals(this.tagValues(), other.tagValues());
    }

    public final String toString() {
        return ToString.builder((String)"GetTagValuesResponse").add("PaginationToken", (Object)this.paginationToken()).add("TagValues", this.hasTagValues() ? this.tagValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "TagValues": {
                return Optional.ofNullable(clazz.cast(this.tagValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTagValuesResponse, T> g) {
        return obj -> g.apply((GetTagValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiResponse.BuilderImpl
    implements Builder {
        private String paginationToken;
        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagValuesResponse model) {
            super(model);
            this.paginationToken(model.paginationToken);
            this.tagValues(model.tagValues);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final Collection<String> getTagValues() {
            if (this.tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValuesOutputListCopier.copy(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValuesOutputListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            this.tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        public GetTagValuesResponse build() {
            return new GetTagValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTagValuesResponse> {
        public Builder paginationToken(String var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);
    }
}

