/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.FailedResourcesMapCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.FailureInfo;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagResourcesResponse
extends ResourceGroupsTaggingApiResponse
implements ToCopyableBuilder<Builder, TagResourcesResponse> {
    private static final SdkField<Map<String, FailureInfo>> FAILED_RESOURCES_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FailedResourcesMap").getter(TagResourcesResponse.getter(TagResourcesResponse::failedResourcesMap)).setter(TagResourcesResponse.setter(Builder::failedResourcesMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedResourcesMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailureInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_RESOURCES_MAP_FIELD));
    private final Map<String, FailureInfo> failedResourcesMap;

    private TagResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.failedResourcesMap = builder.failedResourcesMap;
    }

    public final boolean hasFailedResourcesMap() {
        return this.failedResourcesMap != null && !(this.failedResourcesMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailureInfo> failedResourcesMap() {
        return this.failedResourcesMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedResourcesMap() ? this.failedResourcesMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourcesResponse)) {
            return false;
        }
        TagResourcesResponse other = (TagResourcesResponse)((Object)obj);
        return this.hasFailedResourcesMap() == other.hasFailedResourcesMap() && Objects.equals(this.failedResourcesMap(), other.failedResourcesMap());
    }

    public final String toString() {
        return ToString.builder((String)"TagResourcesResponse").add("FailedResourcesMap", this.hasFailedResourcesMap() ? this.failedResourcesMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedResourcesMap": {
                return Optional.ofNullable(clazz.cast(this.failedResourcesMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagResourcesResponse, T> g) {
        return obj -> g.apply((TagResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiResponse.BuilderImpl
    implements Builder {
        private Map<String, FailureInfo> failedResourcesMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagResourcesResponse model) {
            super(model);
            this.failedResourcesMap(model.failedResourcesMap);
        }

        public final Map<String, FailureInfo.Builder> getFailedResourcesMap() {
            Map<String, FailureInfo.Builder> result = FailedResourcesMapCopier.copyToBuilder(this.failedResourcesMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedResourcesMap(Map<String, FailureInfo.BuilderImpl> failedResourcesMap) {
            this.failedResourcesMap = FailedResourcesMapCopier.copyFromBuilder(failedResourcesMap);
        }

        @Override
        public final Builder failedResourcesMap(Map<String, FailureInfo> failedResourcesMap) {
            this.failedResourcesMap = FailedResourcesMapCopier.copy(failedResourcesMap);
            return this;
        }

        @Override
        public TagResourcesResponse build() {
            return new TagResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TagResourcesResponse> {
        public Builder failedResourcesMap(Map<String, FailureInfo> var1);
    }
}

