/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycluster.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycluster.model.ArnsCopier;
import software.amazon.awssdk.services.route53recoverycluster.model.Route53RecoveryClusterRequest;
import software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateEntriesCopier;
import software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoutingControlStatesRequest
extends Route53RecoveryClusterRequest
implements ToCopyableBuilder<Builder, UpdateRoutingControlStatesRequest> {
    private static final SdkField<List<UpdateRoutingControlStateEntry>> UPDATE_ROUTING_CONTROL_STATE_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UpdateRoutingControlStateEntries").getter(UpdateRoutingControlStatesRequest.getter(UpdateRoutingControlStatesRequest::updateRoutingControlStateEntries)).setter(UpdateRoutingControlStatesRequest.setter(Builder::updateRoutingControlStateEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRoutingControlStateEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateRoutingControlStateEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAFETY_RULES_TO_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SafetyRulesToOverride").getter(UpdateRoutingControlStatesRequest.getter(UpdateRoutingControlStatesRequest::safetyRulesToOverride)).setter(UpdateRoutingControlStatesRequest.setter(Builder::safetyRulesToOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRulesToOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_ROUTING_CONTROL_STATE_ENTRIES_FIELD, SAFETY_RULES_TO_OVERRIDE_FIELD));
    private final List<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries;
    private final List<String> safetyRulesToOverride;

    private UpdateRoutingControlStatesRequest(BuilderImpl builder) {
        super(builder);
        this.updateRoutingControlStateEntries = builder.updateRoutingControlStateEntries;
        this.safetyRulesToOverride = builder.safetyRulesToOverride;
    }

    public final boolean hasUpdateRoutingControlStateEntries() {
        return this.updateRoutingControlStateEntries != null && !(this.updateRoutingControlStateEntries instanceof SdkAutoConstructList);
    }

    public final List<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries() {
        return this.updateRoutingControlStateEntries;
    }

    public final boolean hasSafetyRulesToOverride() {
        return this.safetyRulesToOverride != null && !(this.safetyRulesToOverride instanceof SdkAutoConstructList);
    }

    public final List<String> safetyRulesToOverride() {
        return this.safetyRulesToOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateRoutingControlStateEntries() ? this.updateRoutingControlStateEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSafetyRulesToOverride() ? this.safetyRulesToOverride() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingControlStatesRequest)) {
            return false;
        }
        UpdateRoutingControlStatesRequest other = (UpdateRoutingControlStatesRequest)((Object)obj);
        return this.hasUpdateRoutingControlStateEntries() == other.hasUpdateRoutingControlStateEntries() && Objects.equals(this.updateRoutingControlStateEntries(), other.updateRoutingControlStateEntries()) && this.hasSafetyRulesToOverride() == other.hasSafetyRulesToOverride() && Objects.equals(this.safetyRulesToOverride(), other.safetyRulesToOverride());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRoutingControlStatesRequest").add("UpdateRoutingControlStateEntries", this.hasUpdateRoutingControlStateEntries() ? this.updateRoutingControlStateEntries() : null).add("SafetyRulesToOverride", this.hasSafetyRulesToOverride() ? this.safetyRulesToOverride() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateRoutingControlStateEntries": {
                return Optional.ofNullable(clazz.cast(this.updateRoutingControlStateEntries()));
            }
            case "SafetyRulesToOverride": {
                return Optional.ofNullable(clazz.cast(this.safetyRulesToOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingControlStatesRequest, T> g) {
        return obj -> g.apply((UpdateRoutingControlStatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryClusterRequest.BuilderImpl
    implements Builder {
        private List<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries = DefaultSdkAutoConstructList.getInstance();
        private List<String> safetyRulesToOverride = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingControlStatesRequest model) {
            super(model);
            this.updateRoutingControlStateEntries(model.updateRoutingControlStateEntries);
            this.safetyRulesToOverride(model.safetyRulesToOverride);
        }

        public final List<UpdateRoutingControlStateEntry.Builder> getUpdateRoutingControlStateEntries() {
            List<UpdateRoutingControlStateEntry.Builder> result = UpdateRoutingControlStateEntriesCopier.copyToBuilder(this.updateRoutingControlStateEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateRoutingControlStateEntries(Collection<UpdateRoutingControlStateEntry.BuilderImpl> updateRoutingControlStateEntries) {
            this.updateRoutingControlStateEntries = UpdateRoutingControlStateEntriesCopier.copyFromBuilder(updateRoutingControlStateEntries);
        }

        @Override
        public final Builder updateRoutingControlStateEntries(Collection<UpdateRoutingControlStateEntry> updateRoutingControlStateEntries) {
            this.updateRoutingControlStateEntries = UpdateRoutingControlStateEntriesCopier.copy(updateRoutingControlStateEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateRoutingControlStateEntries(UpdateRoutingControlStateEntry ... updateRoutingControlStateEntries) {
            this.updateRoutingControlStateEntries(Arrays.asList(updateRoutingControlStateEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateRoutingControlStateEntries(Consumer<UpdateRoutingControlStateEntry.Builder> ... updateRoutingControlStateEntries) {
            this.updateRoutingControlStateEntries(Stream.of(updateRoutingControlStateEntries).map(c -> (UpdateRoutingControlStateEntry)((UpdateRoutingControlStateEntry.Builder)UpdateRoutingControlStateEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSafetyRulesToOverride() {
            if (this.safetyRulesToOverride instanceof SdkAutoConstructList) {
                return null;
            }
            return this.safetyRulesToOverride;
        }

        public final void setSafetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
        }

        @Override
        public final Builder safetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder safetyRulesToOverride(String ... safetyRulesToOverride) {
            this.safetyRulesToOverride(Arrays.asList(safetyRulesToOverride));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingControlStatesRequest build() {
            return new UpdateRoutingControlStatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryClusterRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoutingControlStatesRequest> {
        public Builder updateRoutingControlStateEntries(Collection<UpdateRoutingControlStateEntry> var1);

        public Builder updateRoutingControlStateEntries(UpdateRoutingControlStateEntry ... var1);

        public Builder updateRoutingControlStateEntries(Consumer<UpdateRoutingControlStateEntry.Builder> ... var1);

        public Builder safetyRulesToOverride(Collection<String> var1);

        public Builder safetyRulesToOverride(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

