/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse;

public class ListClustersIterable
implements SdkIterable<ListClustersResponse> {
    private final Route53RecoveryControlConfigClient client;
    private final ListClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClustersIterable(Route53RecoveryControlConfigClient client, ListClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListClustersResponseFetcher();
    }

    public Iterator<ListClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListClustersResponseFetcher
    implements SyncPageFetcher<ListClustersResponse> {
        private ListClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClustersResponse nextPage(ListClustersResponse previousPage) {
            if (previousPage == null) {
                return ListClustersIterable.this.client.listClusters(ListClustersIterable.this.firstRequest);
            }
            return ListClustersIterable.this.client.listClusters((ListClustersRequest)((Object)ListClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

