/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.RuleResult;

public class GetReadinessCheckResourceStatusPublisher
implements SdkPublisher<GetReadinessCheckResourceStatusResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final GetReadinessCheckResourceStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetReadinessCheckResourceStatusPublisher(Route53RecoveryReadinessAsyncClient client, GetReadinessCheckResourceStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetReadinessCheckResourceStatusPublisher(Route53RecoveryReadinessAsyncClient client, GetReadinessCheckResourceStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetReadinessCheckResourceStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetReadinessCheckResourceStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RuleResult> rules() {
        Function<GetReadinessCheckResourceStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetReadinessCheckResourceStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetReadinessCheckResourceStatusResponseFetcher
    implements AsyncPageFetcher<GetReadinessCheckResourceStatusResponse> {
        private GetReadinessCheckResourceStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetReadinessCheckResourceStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetReadinessCheckResourceStatusResponse> nextPage(GetReadinessCheckResourceStatusResponse previousPage) {
            if (previousPage == null) {
                return GetReadinessCheckResourceStatusPublisher.this.client.getReadinessCheckResourceStatus(GetReadinessCheckResourceStatusPublisher.this.firstRequest);
            }
            return GetReadinessCheckResourceStatusPublisher.this.client.getReadinessCheckResourceStatus((GetReadinessCheckResourceStatusRequest)((Object)GetReadinessCheckResourceStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

