/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType;
import software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement;
import software.amazon.awssdk.services.sagemaker.model.AuthMode;
import software.amazon.awssdk.services.sagemaker.model.DomainSettings;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SubnetsCopier;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateDomainRequest.getter(CreateDomainRequest::domainName)).setter(CreateDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthMode").getter(CreateDomainRequest.getter(CreateDomainRequest::authModeAsString)).setter(CreateDomainRequest.setter(Builder::authMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()}).build();
    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultUserSettings").getter(CreateDomainRequest.getter(CreateDomainRequest::defaultUserSettings)).setter(CreateDomainRequest.setter(Builder::defaultUserSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateDomainRequest.getter(CreateDomainRequest::subnetIds)).setter(CreateDomainRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateDomainRequest.getter(CreateDomainRequest::vpcId)).setter(CreateDomainRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDomainRequest.getter(CreateDomainRequest::tags)).setter(CreateDomainRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APP_NETWORK_ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppNetworkAccessType").getter(CreateDomainRequest.getter(CreateDomainRequest::appNetworkAccessTypeAsString)).setter(CreateDomainRequest.setter(Builder::appNetworkAccessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppNetworkAccessType").build()}).build();
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeEfsFileSystemKmsKeyId").getter(CreateDomainRequest.getter(CreateDomainRequest::homeEfsFileSystemKmsKeyId)).setter(CreateDomainRequest.setter(Builder::homeEfsFileSystemKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemKmsKeyId").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateDomainRequest.getter(CreateDomainRequest::kmsKeyId)).setter(CreateDomainRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> APP_SECURITY_GROUP_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppSecurityGroupManagement").getter(CreateDomainRequest.getter(CreateDomainRequest::appSecurityGroupManagementAsString)).setter(CreateDomainRequest.setter(Builder::appSecurityGroupManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSecurityGroupManagement").build()}).build();
    private static final SdkField<DomainSettings> DOMAIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainSettings").getter(CreateDomainRequest.getter(CreateDomainRequest::domainSettings)).setter(CreateDomainRequest.setter(Builder::domainSettings)).constructor(DomainSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, AUTH_MODE_FIELD, DEFAULT_USER_SETTINGS_FIELD, SUBNET_IDS_FIELD, VPC_ID_FIELD, TAGS_FIELD, APP_NETWORK_ACCESS_TYPE_FIELD, HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD, KMS_KEY_ID_FIELD, APP_SECURITY_GROUP_MANAGEMENT_FIELD, DOMAIN_SETTINGS_FIELD));
    private final String domainName;
    private final String authMode;
    private final UserSettings defaultUserSettings;
    private final List<String> subnetIds;
    private final String vpcId;
    private final List<Tag> tags;
    private final String appNetworkAccessType;
    private final String homeEfsFileSystemKmsKeyId;
    private final String kmsKeyId;
    private final String appSecurityGroupManagement;
    private final DomainSettings domainSettings;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.authMode = builder.authMode;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.subnetIds = builder.subnetIds;
        this.vpcId = builder.vpcId;
        this.tags = builder.tags;
        this.appNetworkAccessType = builder.appNetworkAccessType;
        this.homeEfsFileSystemKmsKeyId = builder.homeEfsFileSystemKmsKeyId;
        this.kmsKeyId = builder.kmsKeyId;
        this.appSecurityGroupManagement = builder.appSecurityGroupManagement;
        this.domainSettings = builder.domainSettings;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final AuthMode authMode() {
        return AuthMode.fromValue(this.authMode);
    }

    public final String authModeAsString() {
        return this.authMode;
    }

    public final UserSettings defaultUserSettings() {
        return this.defaultUserSettings;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final AppNetworkAccessType appNetworkAccessType() {
        return AppNetworkAccessType.fromValue(this.appNetworkAccessType);
    }

    public final String appNetworkAccessTypeAsString() {
        return this.appNetworkAccessType;
    }

    @Deprecated
    public final String homeEfsFileSystemKmsKeyId() {
        return this.homeEfsFileSystemKmsKeyId;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final AppSecurityGroupManagement appSecurityGroupManagement() {
        return AppSecurityGroupManagement.fromValue(this.appSecurityGroupManagement);
    }

    public final String appSecurityGroupManagementAsString() {
        return this.appSecurityGroupManagement;
    }

    public final DomainSettings domainSettings() {
        return this.domainSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appNetworkAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeEfsFileSystemKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appSecurityGroupManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.authModeAsString(), other.authModeAsString()) && Objects.equals(this.defaultUserSettings(), other.defaultUserSettings()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.appNetworkAccessTypeAsString(), other.appNetworkAccessTypeAsString()) && Objects.equals(this.homeEfsFileSystemKmsKeyId(), other.homeEfsFileSystemKmsKeyId()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.appSecurityGroupManagementAsString(), other.appSecurityGroupManagementAsString()) && Objects.equals(this.domainSettings(), other.domainSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainRequest").add("DomainName", (Object)this.domainName()).add("AuthMode", (Object)this.authModeAsString()).add("DefaultUserSettings", (Object)this.defaultUserSettings()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("VpcId", (Object)this.vpcId()).add("Tags", this.hasTags() ? this.tags() : null).add("AppNetworkAccessType", (Object)this.appNetworkAccessTypeAsString()).add("HomeEfsFileSystemKmsKeyId", (Object)this.homeEfsFileSystemKmsKeyId()).add("KmsKeyId", (Object)this.kmsKeyId()).add("AppSecurityGroupManagement", (Object)this.appSecurityGroupManagementAsString()).add("DomainSettings", (Object)this.domainSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AuthMode": {
                return Optional.ofNullable(clazz.cast(this.authModeAsString()));
            }
            case "DefaultUserSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultUserSettings()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AppNetworkAccessType": {
                return Optional.ofNullable(clazz.cast(this.appNetworkAccessTypeAsString()));
            }
            case "HomeEfsFileSystemKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.homeEfsFileSystemKmsKeyId()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "AppSecurityGroupManagement": {
                return Optional.ofNullable(clazz.cast(this.appSecurityGroupManagementAsString()));
            }
            case "DomainSettings": {
                return Optional.ofNullable(clazz.cast(this.domainSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String authMode;
        private UserSettings defaultUserSettings;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String appNetworkAccessType;
        private String homeEfsFileSystemKmsKeyId;
        private String kmsKeyId;
        private String appSecurityGroupManagement;
        private DomainSettings domainSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.authMode(model.authMode);
            this.defaultUserSettings(model.defaultUserSettings);
            this.subnetIds(model.subnetIds);
            this.vpcId(model.vpcId);
            this.tags(model.tags);
            this.appNetworkAccessType(model.appNetworkAccessType);
            this.homeEfsFileSystemKmsKeyId(model.homeEfsFileSystemKmsKeyId);
            this.kmsKeyId(model.kmsKeyId);
            this.appSecurityGroupManagement(model.appSecurityGroupManagement);
            this.domainSettings(model.domainSettings);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAuthMode() {
            return this.authMode;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return this.defaultUserSettings != null ? this.defaultUserSettings.toBuilder() : null;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAppNetworkAccessType() {
            return this.appNetworkAccessType;
        }

        public final void setAppNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
        }

        @Override
        public final Builder appNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        @Override
        public final Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType) {
            this.appNetworkAccessType(appNetworkAccessType == null ? null : appNetworkAccessType.toString());
            return this;
        }

        @Deprecated
        public final String getHomeEfsFileSystemKmsKeyId() {
            return this.homeEfsFileSystemKmsKeyId;
        }

        @Deprecated
        public final void setHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
        }

        @Override
        @Deprecated
        public final Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getAppSecurityGroupManagement() {
            return this.appSecurityGroupManagement;
        }

        public final void setAppSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
        }

        @Override
        public final Builder appSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
            return this;
        }

        @Override
        public final Builder appSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement) {
            this.appSecurityGroupManagement(appSecurityGroupManagement == null ? null : appSecurityGroupManagement.toString());
            return this;
        }

        public final DomainSettings.Builder getDomainSettings() {
            return this.domainSettings != null ? this.domainSettings.toBuilder() : null;
        }

        public final void setDomainSettings(DomainSettings.BuilderImpl domainSettings) {
            this.domainSettings = domainSettings != null ? domainSettings.build() : null;
        }

        @Override
        public final Builder domainSettings(DomainSettings domainSettings) {
            this.domainSettings = domainSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainRequest> {
        public Builder domainName(String var1);

        public Builder authMode(String var1);

        public Builder authMode(AuthMode var1);

        public Builder defaultUserSettings(UserSettings var1);

        default public Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return this.defaultUserSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(defaultUserSettings)).build());
        }

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder vpcId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder appNetworkAccessType(String var1);

        public Builder appNetworkAccessType(AppNetworkAccessType var1);

        @Deprecated
        public Builder homeEfsFileSystemKmsKeyId(String var1);

        public Builder kmsKeyId(String var1);

        public Builder appSecurityGroupManagement(String var1);

        public Builder appSecurityGroupManagement(AppSecurityGroupManagement var1);

        public Builder domainSettings(DomainSettings var1);

        default public Builder domainSettings(Consumer<DomainSettings.Builder> domainSettings) {
            return this.domainSettings((DomainSettings)((DomainSettings.Builder)DomainSettings.builder().applyMutation(domainSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

