/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.Action;
import software.amazon.awssdk.services.securityhub.model.Compliance;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.services.securityhub.model.FindingProviderFields;
import software.amazon.awssdk.services.securityhub.model.Malware;
import software.amazon.awssdk.services.securityhub.model.MalwareListCopier;
import software.amazon.awssdk.services.securityhub.model.Network;
import software.amazon.awssdk.services.securityhub.model.NetworkPathComponent;
import software.amazon.awssdk.services.securityhub.model.NetworkPathListCopier;
import software.amazon.awssdk.services.securityhub.model.Note;
import software.amazon.awssdk.services.securityhub.model.PatchSummary;
import software.amazon.awssdk.services.securityhub.model.ProcessDetails;
import software.amazon.awssdk.services.securityhub.model.RecordState;
import software.amazon.awssdk.services.securityhub.model.RelatedFinding;
import software.amazon.awssdk.services.securityhub.model.RelatedFindingListCopier;
import software.amazon.awssdk.services.securityhub.model.Remediation;
import software.amazon.awssdk.services.securityhub.model.Resource;
import software.amazon.awssdk.services.securityhub.model.ResourceListCopier;
import software.amazon.awssdk.services.securityhub.model.Severity;
import software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator;
import software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorListCopier;
import software.amazon.awssdk.services.securityhub.model.TypeListCopier;
import software.amazon.awssdk.services.securityhub.model.VerificationState;
import software.amazon.awssdk.services.securityhub.model.Vulnerability;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityListCopier;
import software.amazon.awssdk.services.securityhub.model.Workflow;
import software.amazon.awssdk.services.securityhub.model.WorkflowState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsSecurityFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsSecurityFinding> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersion").getter(AwsSecurityFinding.getter(AwsSecurityFinding::schemaVersion)).setter(AwsSecurityFinding.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsSecurityFinding.getter(AwsSecurityFinding::id)).setter(AwsSecurityFinding.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductArn").getter(AwsSecurityFinding.getter(AwsSecurityFinding::productArn)).setter(AwsSecurityFinding.setter(Builder::productArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(AwsSecurityFinding.getter(AwsSecurityFinding::productName)).setter(AwsSecurityFinding.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(AwsSecurityFinding.getter(AwsSecurityFinding::companyName)).setter(AwsSecurityFinding.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(AwsSecurityFinding.getter(AwsSecurityFinding::region)).setter(AwsSecurityFinding.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> GENERATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratorId").getter(AwsSecurityFinding.getter(AwsSecurityFinding::generatorId)).setter(AwsSecurityFinding.setter(Builder::generatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratorId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(AwsSecurityFinding.getter(AwsSecurityFinding::awsAccountId)).setter(AwsSecurityFinding.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(AwsSecurityFinding.getter(AwsSecurityFinding::types)).setter(AwsSecurityFinding.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIRST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstObservedAt").getter(AwsSecurityFinding.getter(AwsSecurityFinding::firstObservedAt)).setter(AwsSecurityFinding.setter(Builder::firstObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstObservedAt").build()}).build();
    private static final SdkField<String> LAST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastObservedAt").getter(AwsSecurityFinding.getter(AwsSecurityFinding::lastObservedAt)).setter(AwsSecurityFinding.setter(Builder::lastObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObservedAt").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(AwsSecurityFinding.getter(AwsSecurityFinding::createdAt)).setter(AwsSecurityFinding.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedAt").getter(AwsSecurityFinding.getter(AwsSecurityFinding::updatedAt)).setter(AwsSecurityFinding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<Severity> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Severity").getter(AwsSecurityFinding.getter(AwsSecurityFinding::severity)).setter(AwsSecurityFinding.setter(Builder::severity)).constructor(Severity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Confidence").getter(AwsSecurityFinding.getter(AwsSecurityFinding::confidence)).setter(AwsSecurityFinding.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Criticality").getter(AwsSecurityFinding.getter(AwsSecurityFinding::criticality)).setter(AwsSecurityFinding.setter(Builder::criticality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(AwsSecurityFinding.getter(AwsSecurityFinding::title)).setter(AwsSecurityFinding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsSecurityFinding.getter(AwsSecurityFinding::description)).setter(AwsSecurityFinding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Remediation").getter(AwsSecurityFinding.getter(AwsSecurityFinding::remediation)).setter(AwsSecurityFinding.setter(Builder::remediation)).constructor(Remediation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remediation").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceUrl").getter(AwsSecurityFinding.getter(AwsSecurityFinding::sourceUrl)).setter(AwsSecurityFinding.setter(Builder::sourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()}).build();
    private static final SdkField<Map<String, String>> PRODUCT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ProductFields").getter(AwsSecurityFinding.getter(AwsSecurityFinding::productFields)).setter(AwsSecurityFinding.setter(Builder::productFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> USER_DEFINED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserDefinedFields").getter(AwsSecurityFinding.getter(AwsSecurityFinding::userDefinedFields)).setter(AwsSecurityFinding.setter(Builder::userDefinedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Malware>> MALWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Malware").getter(AwsSecurityFinding.getter(AwsSecurityFinding::malware)).setter(AwsSecurityFinding.setter(Builder::malware)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Malware").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Malware::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Network> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Network").getter(AwsSecurityFinding.getter(AwsSecurityFinding::network)).setter(AwsSecurityFinding.setter(Builder::network)).constructor(Network::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Network").build()}).build();
    private static final SdkField<List<NetworkPathComponent>> NETWORK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkPath").getter(AwsSecurityFinding.getter(AwsSecurityFinding::networkPath)).setter(AwsSecurityFinding.setter(Builder::networkPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkPathComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProcessDetails> PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Process").getter(AwsSecurityFinding.getter(AwsSecurityFinding::process)).setter(AwsSecurityFinding.setter(Builder::process)).constructor(ProcessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Process").build()}).build();
    private static final SdkField<List<ThreatIntelIndicator>> THREAT_INTEL_INDICATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThreatIntelIndicators").getter(AwsSecurityFinding.getter(AwsSecurityFinding::threatIntelIndicators)).setter(AwsSecurityFinding.setter(Builder::threatIntelIndicators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThreatIntelIndicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(AwsSecurityFinding.getter(AwsSecurityFinding::resources)).setter(AwsSecurityFinding.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Compliance> COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Compliance").getter(AwsSecurityFinding.getter(AwsSecurityFinding::compliance)).setter(AwsSecurityFinding.setter(Builder::compliance)).constructor(Compliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()}).build();
    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationState").getter(AwsSecurityFinding.getter(AwsSecurityFinding::verificationStateAsString)).setter(AwsSecurityFinding.setter(Builder::verificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build()}).build();
    private static final SdkField<String> WORKFLOW_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowState").getter(AwsSecurityFinding.getter(AwsSecurityFinding::workflowStateAsString)).setter(AwsSecurityFinding.setter(Builder::workflowState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowState").build()}).build();
    private static final SdkField<Workflow> WORKFLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Workflow").getter(AwsSecurityFinding.getter(AwsSecurityFinding::workflow)).setter(AwsSecurityFinding.setter(Builder::workflow)).constructor(Workflow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()}).build();
    private static final SdkField<String> RECORD_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordState").getter(AwsSecurityFinding.getter(AwsSecurityFinding::recordStateAsString)).setter(AwsSecurityFinding.setter(Builder::recordState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordState").build()}).build();
    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedFindings").getter(AwsSecurityFinding.getter(AwsSecurityFinding::relatedFindings)).setter(AwsSecurityFinding.setter(Builder::relatedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Note> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Note").getter(AwsSecurityFinding.getter(AwsSecurityFinding::note)).setter(AwsSecurityFinding.setter(Builder::note)).constructor(Note::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()}).build();
    private static final SdkField<List<Vulnerability>> VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Vulnerabilities").getter(AwsSecurityFinding.getter(AwsSecurityFinding::vulnerabilities)).setter(AwsSecurityFinding.setter(Builder::vulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Vulnerability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PatchSummary> PATCH_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PatchSummary").getter(AwsSecurityFinding.getter(AwsSecurityFinding::patchSummary)).setter(AwsSecurityFinding.setter(Builder::patchSummary)).constructor(PatchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchSummary").build()}).build();
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(AwsSecurityFinding.getter(AwsSecurityFinding::action)).setter(AwsSecurityFinding.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<FindingProviderFields> FINDING_PROVIDER_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindingProviderFields").getter(AwsSecurityFinding.getter(AwsSecurityFinding::findingProviderFields)).setter(AwsSecurityFinding.setter(Builder::findingProviderFields)).constructor(FindingProviderFields::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingProviderFields").build()}).build();
    private static final SdkField<Boolean> SAMPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Sample").getter(AwsSecurityFinding.getter(AwsSecurityFinding::sample)).setter(AwsSecurityFinding.setter(Builder::sample)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sample").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD, ID_FIELD, PRODUCT_ARN_FIELD, PRODUCT_NAME_FIELD, COMPANY_NAME_FIELD, REGION_FIELD, GENERATOR_ID_FIELD, AWS_ACCOUNT_ID_FIELD, TYPES_FIELD, FIRST_OBSERVED_AT_FIELD, LAST_OBSERVED_AT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, SEVERITY_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, REMEDIATION_FIELD, SOURCE_URL_FIELD, PRODUCT_FIELDS_FIELD, USER_DEFINED_FIELDS_FIELD, MALWARE_FIELD, NETWORK_FIELD, NETWORK_PATH_FIELD, PROCESS_FIELD, THREAT_INTEL_INDICATORS_FIELD, RESOURCES_FIELD, COMPLIANCE_FIELD, VERIFICATION_STATE_FIELD, WORKFLOW_STATE_FIELD, WORKFLOW_FIELD, RECORD_STATE_FIELD, RELATED_FINDINGS_FIELD, NOTE_FIELD, VULNERABILITIES_FIELD, PATCH_SUMMARY_FIELD, ACTION_FIELD, FINDING_PROVIDER_FIELDS_FIELD, SAMPLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String schemaVersion;
    private final String id;
    private final String productArn;
    private final String productName;
    private final String companyName;
    private final String region;
    private final String generatorId;
    private final String awsAccountId;
    private final List<String> types;
    private final String firstObservedAt;
    private final String lastObservedAt;
    private final String createdAt;
    private final String updatedAt;
    private final Severity severity;
    private final Integer confidence;
    private final Integer criticality;
    private final String title;
    private final String description;
    private final Remediation remediation;
    private final String sourceUrl;
    private final Map<String, String> productFields;
    private final Map<String, String> userDefinedFields;
    private final List<Malware> malware;
    private final Network network;
    private final List<NetworkPathComponent> networkPath;
    private final ProcessDetails process;
    private final List<ThreatIntelIndicator> threatIntelIndicators;
    private final List<Resource> resources;
    private final Compliance compliance;
    private final String verificationState;
    private final String workflowState;
    private final Workflow workflow;
    private final String recordState;
    private final List<RelatedFinding> relatedFindings;
    private final Note note;
    private final List<Vulnerability> vulnerabilities;
    private final PatchSummary patchSummary;
    private final Action action;
    private final FindingProviderFields findingProviderFields;
    private final Boolean sample;

    private AwsSecurityFinding(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.id = builder.id;
        this.productArn = builder.productArn;
        this.productName = builder.productName;
        this.companyName = builder.companyName;
        this.region = builder.region;
        this.generatorId = builder.generatorId;
        this.awsAccountId = builder.awsAccountId;
        this.types = builder.types;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.severity = builder.severity;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.title = builder.title;
        this.description = builder.description;
        this.remediation = builder.remediation;
        this.sourceUrl = builder.sourceUrl;
        this.productFields = builder.productFields;
        this.userDefinedFields = builder.userDefinedFields;
        this.malware = builder.malware;
        this.network = builder.network;
        this.networkPath = builder.networkPath;
        this.process = builder.process;
        this.threatIntelIndicators = builder.threatIntelIndicators;
        this.resources = builder.resources;
        this.compliance = builder.compliance;
        this.verificationState = builder.verificationState;
        this.workflowState = builder.workflowState;
        this.workflow = builder.workflow;
        this.recordState = builder.recordState;
        this.relatedFindings = builder.relatedFindings;
        this.note = builder.note;
        this.vulnerabilities = builder.vulnerabilities;
        this.patchSummary = builder.patchSummary;
        this.action = builder.action;
        this.findingProviderFields = builder.findingProviderFields;
        this.sample = builder.sample;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final String id() {
        return this.id;
    }

    public final String productArn() {
        return this.productArn;
    }

    public final String productName() {
        return this.productName;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final String region() {
        return this.region;
    }

    public final String generatorId() {
        return this.generatorId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public final String firstObservedAt() {
        return this.firstObservedAt;
    }

    public final String lastObservedAt() {
        return this.lastObservedAt;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final String updatedAt() {
        return this.updatedAt;
    }

    public final Severity severity() {
        return this.severity;
    }

    public final Integer confidence() {
        return this.confidence;
    }

    public final Integer criticality() {
        return this.criticality;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final Remediation remediation() {
        return this.remediation;
    }

    public final String sourceUrl() {
        return this.sourceUrl;
    }

    public final boolean hasProductFields() {
        return this.productFields != null && !(this.productFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> productFields() {
        return this.productFields;
    }

    public final boolean hasUserDefinedFields() {
        return this.userDefinedFields != null && !(this.userDefinedFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userDefinedFields() {
        return this.userDefinedFields;
    }

    public final boolean hasMalware() {
        return this.malware != null && !(this.malware instanceof SdkAutoConstructList);
    }

    public final List<Malware> malware() {
        return this.malware;
    }

    public final Network network() {
        return this.network;
    }

    public final boolean hasNetworkPath() {
        return this.networkPath != null && !(this.networkPath instanceof SdkAutoConstructList);
    }

    public final List<NetworkPathComponent> networkPath() {
        return this.networkPath;
    }

    public final ProcessDetails process() {
        return this.process;
    }

    public final boolean hasThreatIntelIndicators() {
        return this.threatIntelIndicators != null && !(this.threatIntelIndicators instanceof SdkAutoConstructList);
    }

    public final List<ThreatIntelIndicator> threatIntelIndicators() {
        return this.threatIntelIndicators;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final Compliance compliance() {
        return this.compliance;
    }

    public final VerificationState verificationState() {
        return VerificationState.fromValue(this.verificationState);
    }

    public final String verificationStateAsString() {
        return this.verificationState;
    }

    public final WorkflowState workflowState() {
        return WorkflowState.fromValue(this.workflowState);
    }

    public final String workflowStateAsString() {
        return this.workflowState;
    }

    public final Workflow workflow() {
        return this.workflow;
    }

    public final RecordState recordState() {
        return RecordState.fromValue(this.recordState);
    }

    public final String recordStateAsString() {
        return this.recordState;
    }

    public final boolean hasRelatedFindings() {
        return this.relatedFindings != null && !(this.relatedFindings instanceof SdkAutoConstructList);
    }

    public final List<RelatedFinding> relatedFindings() {
        return this.relatedFindings;
    }

    public final Note note() {
        return this.note;
    }

    public final boolean hasVulnerabilities() {
        return this.vulnerabilities != null && !(this.vulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<Vulnerability> vulnerabilities() {
        return this.vulnerabilities;
    }

    public final PatchSummary patchSummary() {
        return this.patchSummary;
    }

    public final Action action() {
        return this.action;
    }

    public final FindingProviderFields findingProviderFields() {
        return this.findingProviderFields;
    }

    public final Boolean sample() {
        return this.sample;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.productArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.criticality());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductFields() ? this.productFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserDefinedFields() ? this.userDefinedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMalware() ? this.malware() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.network());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkPath() ? this.networkPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.process());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatIntelIndicators() ? this.threatIntelIndicators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compliance());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflow());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedFindings() ? this.relatedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVulnerabilities() ? this.vulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.patchSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingProviderFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.sample());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSecurityFinding)) {
            return false;
        }
        AwsSecurityFinding other = (AwsSecurityFinding)obj;
        return Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.productArn(), other.productArn()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.generatorId(), other.generatorId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && Objects.equals(this.firstObservedAt(), other.firstObservedAt()) && Objects.equals(this.lastObservedAt(), other.lastObservedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.criticality(), other.criticality()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.sourceUrl(), other.sourceUrl()) && this.hasProductFields() == other.hasProductFields() && Objects.equals(this.productFields(), other.productFields()) && this.hasUserDefinedFields() == other.hasUserDefinedFields() && Objects.equals(this.userDefinedFields(), other.userDefinedFields()) && this.hasMalware() == other.hasMalware() && Objects.equals(this.malware(), other.malware()) && Objects.equals(this.network(), other.network()) && this.hasNetworkPath() == other.hasNetworkPath() && Objects.equals(this.networkPath(), other.networkPath()) && Objects.equals(this.process(), other.process()) && this.hasThreatIntelIndicators() == other.hasThreatIntelIndicators() && Objects.equals(this.threatIntelIndicators(), other.threatIntelIndicators()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.compliance(), other.compliance()) && Objects.equals(this.verificationStateAsString(), other.verificationStateAsString()) && Objects.equals(this.workflowStateAsString(), other.workflowStateAsString()) && Objects.equals(this.workflow(), other.workflow()) && Objects.equals(this.recordStateAsString(), other.recordStateAsString()) && this.hasRelatedFindings() == other.hasRelatedFindings() && Objects.equals(this.relatedFindings(), other.relatedFindings()) && Objects.equals(this.note(), other.note()) && this.hasVulnerabilities() == other.hasVulnerabilities() && Objects.equals(this.vulnerabilities(), other.vulnerabilities()) && Objects.equals(this.patchSummary(), other.patchSummary()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.findingProviderFields(), other.findingProviderFields()) && Objects.equals(this.sample(), other.sample());
    }

    public final String toString() {
        return ToString.builder((String)"AwsSecurityFinding").add("SchemaVersion", (Object)this.schemaVersion()).add("Id", (Object)this.id()).add("ProductArn", (Object)this.productArn()).add("ProductName", (Object)this.productName()).add("CompanyName", (Object)this.companyName()).add("Region", (Object)this.region()).add("GeneratorId", (Object)this.generatorId()).add("AwsAccountId", (Object)this.awsAccountId()).add("Types", this.hasTypes() ? this.types() : null).add("FirstObservedAt", (Object)this.firstObservedAt()).add("LastObservedAt", (Object)this.lastObservedAt()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Severity", (Object)this.severity()).add("Confidence", (Object)this.confidence()).add("Criticality", (Object)this.criticality()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Remediation", (Object)this.remediation()).add("SourceUrl", (Object)this.sourceUrl()).add("ProductFields", this.hasProductFields() ? this.productFields() : null).add("UserDefinedFields", this.hasUserDefinedFields() ? this.userDefinedFields() : null).add("Malware", this.hasMalware() ? this.malware() : null).add("Network", (Object)this.network()).add("NetworkPath", this.hasNetworkPath() ? this.networkPath() : null).add("Process", (Object)this.process()).add("ThreatIntelIndicators", this.hasThreatIntelIndicators() ? this.threatIntelIndicators() : null).add("Resources", this.hasResources() ? this.resources() : null).add("Compliance", (Object)this.compliance()).add("VerificationState", (Object)this.verificationStateAsString()).add("WorkflowState", (Object)this.workflowStateAsString()).add("Workflow", (Object)this.workflow()).add("RecordState", (Object)this.recordStateAsString()).add("RelatedFindings", this.hasRelatedFindings() ? this.relatedFindings() : null).add("Note", (Object)this.note()).add("Vulnerabilities", this.hasVulnerabilities() ? this.vulnerabilities() : null).add("PatchSummary", (Object)this.patchSummary()).add("Action", (Object)this.action()).add("FindingProviderFields", (Object)this.findingProviderFields()).add("Sample", (Object)this.sample()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ProductArn": {
                return Optional.ofNullable(clazz.cast(this.productArn()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "GeneratorId": {
                return Optional.ofNullable(clazz.cast(this.generatorId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "FirstObservedAt": {
                return Optional.ofNullable(clazz.cast(this.firstObservedAt()));
            }
            case "LastObservedAt": {
                return Optional.ofNullable(clazz.cast(this.lastObservedAt()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Criticality": {
                return Optional.ofNullable(clazz.cast(this.criticality()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "SourceUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceUrl()));
            }
            case "ProductFields": {
                return Optional.ofNullable(clazz.cast(this.productFields()));
            }
            case "UserDefinedFields": {
                return Optional.ofNullable(clazz.cast(this.userDefinedFields()));
            }
            case "Malware": {
                return Optional.ofNullable(clazz.cast(this.malware()));
            }
            case "Network": {
                return Optional.ofNullable(clazz.cast(this.network()));
            }
            case "NetworkPath": {
                return Optional.ofNullable(clazz.cast(this.networkPath()));
            }
            case "Process": {
                return Optional.ofNullable(clazz.cast(this.process()));
            }
            case "ThreatIntelIndicators": {
                return Optional.ofNullable(clazz.cast(this.threatIntelIndicators()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Compliance": {
                return Optional.ofNullable(clazz.cast(this.compliance()));
            }
            case "VerificationState": {
                return Optional.ofNullable(clazz.cast(this.verificationStateAsString()));
            }
            case "WorkflowState": {
                return Optional.ofNullable(clazz.cast(this.workflowStateAsString()));
            }
            case "Workflow": {
                return Optional.ofNullable(clazz.cast(this.workflow()));
            }
            case "RecordState": {
                return Optional.ofNullable(clazz.cast(this.recordStateAsString()));
            }
            case "RelatedFindings": {
                return Optional.ofNullable(clazz.cast(this.relatedFindings()));
            }
            case "Note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
            case "Vulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilities()));
            }
            case "PatchSummary": {
                return Optional.ofNullable(clazz.cast(this.patchSummary()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "FindingProviderFields": {
                return Optional.ofNullable(clazz.cast(this.findingProviderFields()));
            }
            case "Sample": {
                return Optional.ofNullable(clazz.cast(this.sample()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSecurityFinding, T> g) {
        return obj -> g.apply((AwsSecurityFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaVersion;
        private String id;
        private String productArn;
        private String productName;
        private String companyName;
        private String region;
        private String generatorId;
        private String awsAccountId;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private String firstObservedAt;
        private String lastObservedAt;
        private String createdAt;
        private String updatedAt;
        private Severity severity;
        private Integer confidence;
        private Integer criticality;
        private String title;
        private String description;
        private Remediation remediation;
        private String sourceUrl;
        private Map<String, String> productFields = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> userDefinedFields = DefaultSdkAutoConstructMap.getInstance();
        private List<Malware> malware = DefaultSdkAutoConstructList.getInstance();
        private Network network;
        private List<NetworkPathComponent> networkPath = DefaultSdkAutoConstructList.getInstance();
        private ProcessDetails process;
        private List<ThreatIntelIndicator> threatIntelIndicators = DefaultSdkAutoConstructList.getInstance();
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private Compliance compliance;
        private String verificationState;
        private String workflowState;
        private Workflow workflow;
        private String recordState;
        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();
        private Note note;
        private List<Vulnerability> vulnerabilities = DefaultSdkAutoConstructList.getInstance();
        private PatchSummary patchSummary;
        private Action action;
        private FindingProviderFields findingProviderFields;
        private Boolean sample;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSecurityFinding model) {
            this.schemaVersion(model.schemaVersion);
            this.id(model.id);
            this.productArn(model.productArn);
            this.productName(model.productName);
            this.companyName(model.companyName);
            this.region(model.region);
            this.generatorId(model.generatorId);
            this.awsAccountId(model.awsAccountId);
            this.types(model.types);
            this.firstObservedAt(model.firstObservedAt);
            this.lastObservedAt(model.lastObservedAt);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.severity(model.severity);
            this.confidence(model.confidence);
            this.criticality(model.criticality);
            this.title(model.title);
            this.description(model.description);
            this.remediation(model.remediation);
            this.sourceUrl(model.sourceUrl);
            this.productFields(model.productFields);
            this.userDefinedFields(model.userDefinedFields);
            this.malware(model.malware);
            this.network(model.network);
            this.networkPath(model.networkPath);
            this.process(model.process);
            this.threatIntelIndicators(model.threatIntelIndicators);
            this.resources(model.resources);
            this.compliance(model.compliance);
            this.verificationState(model.verificationState);
            this.workflowState(model.workflowState);
            this.workflow(model.workflow);
            this.recordState(model.recordState);
            this.relatedFindings(model.relatedFindings);
            this.note(model.note);
            this.vulnerabilities(model.vulnerabilities);
            this.patchSummary(model.patchSummary);
            this.action(model.action);
            this.findingProviderFields(model.findingProviderFields);
            this.sample(model.sample);
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProductArn() {
            return this.productArn;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getGeneratorId() {
            return this.generatorId;
        }

        public final void setGeneratorId(String generatorId) {
            this.generatorId = generatorId;
        }

        @Override
        public final Builder generatorId(String generatorId) {
            this.generatorId = generatorId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final String getFirstObservedAt() {
            return this.firstObservedAt;
        }

        public final void setFirstObservedAt(String firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(String firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final String getLastObservedAt() {
            return this.lastObservedAt;
        }

        public final void setLastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Severity.Builder getSeverity() {
            return this.severity != null ? this.severity.toBuilder() : null;
        }

        public final void setSeverity(Severity.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Integer getCriticality() {
            return this.criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return this.remediation != null ? this.remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final Map<String, String> getProductFields() {
            if (this.productFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.productFields;
        }

        public final void setProductFields(Map<String, String> productFields) {
            this.productFields = FieldMapCopier.copy(productFields);
        }

        @Override
        public final Builder productFields(Map<String, String> productFields) {
            this.productFields = FieldMapCopier.copy(productFields);
            return this;
        }

        public final Map<String, String> getUserDefinedFields() {
            if (this.userDefinedFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userDefinedFields;
        }

        public final void setUserDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
        }

        @Override
        public final Builder userDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
            return this;
        }

        public final List<Malware.Builder> getMalware() {
            List<Malware.Builder> result = MalwareListCopier.copyToBuilder(this.malware);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMalware(Collection<Malware.BuilderImpl> malware) {
            this.malware = MalwareListCopier.copyFromBuilder(malware);
        }

        @Override
        public final Builder malware(Collection<Malware> malware) {
            this.malware = MalwareListCopier.copy(malware);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malware(Malware ... malware) {
            this.malware(Arrays.asList(malware));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malware(Consumer<Malware.Builder> ... malware) {
            this.malware(Stream.of(malware).map(c -> (Malware)((Malware.Builder)Malware.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Network.Builder getNetwork() {
            return this.network != null ? this.network.toBuilder() : null;
        }

        public final void setNetwork(Network.BuilderImpl network) {
            this.network = network != null ? network.build() : null;
        }

        @Override
        public final Builder network(Network network) {
            this.network = network;
            return this;
        }

        public final List<NetworkPathComponent.Builder> getNetworkPath() {
            List<NetworkPathComponent.Builder> result = NetworkPathListCopier.copyToBuilder(this.networkPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkPath(Collection<NetworkPathComponent.BuilderImpl> networkPath) {
            this.networkPath = NetworkPathListCopier.copyFromBuilder(networkPath);
        }

        @Override
        public final Builder networkPath(Collection<NetworkPathComponent> networkPath) {
            this.networkPath = NetworkPathListCopier.copy(networkPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkPath(NetworkPathComponent ... networkPath) {
            this.networkPath(Arrays.asList(networkPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkPath(Consumer<NetworkPathComponent.Builder> ... networkPath) {
            this.networkPath(Stream.of(networkPath).map(c -> (NetworkPathComponent)((NetworkPathComponent.Builder)NetworkPathComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProcessDetails.Builder getProcess() {
            return this.process != null ? this.process.toBuilder() : null;
        }

        public final void setProcess(ProcessDetails.BuilderImpl process) {
            this.process = process != null ? process.build() : null;
        }

        @Override
        public final Builder process(ProcessDetails process) {
            this.process = process;
            return this;
        }

        public final List<ThreatIntelIndicator.Builder> getThreatIntelIndicators() {
            List<ThreatIntelIndicator.Builder> result = ThreatIntelIndicatorListCopier.copyToBuilder(this.threatIntelIndicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatIntelIndicators(Collection<ThreatIntelIndicator.BuilderImpl> threatIntelIndicators) {
            this.threatIntelIndicators = ThreatIntelIndicatorListCopier.copyFromBuilder(threatIntelIndicators);
        }

        @Override
        public final Builder threatIntelIndicators(Collection<ThreatIntelIndicator> threatIntelIndicators) {
            this.threatIntelIndicators = ThreatIntelIndicatorListCopier.copy(threatIntelIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicators(ThreatIntelIndicator ... threatIntelIndicators) {
            this.threatIntelIndicators(Arrays.asList(threatIntelIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicators(Consumer<ThreatIntelIndicator.Builder> ... threatIntelIndicators) {
            this.threatIntelIndicators(Stream.of(threatIntelIndicators).map(c -> (ThreatIntelIndicator)((ThreatIntelIndicator.Builder)ThreatIntelIndicator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Compliance.Builder getCompliance() {
            return this.compliance != null ? this.compliance.toBuilder() : null;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final String getVerificationState() {
            return this.verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final String getWorkflowState() {
            return this.workflowState;
        }

        public final void setWorkflowState(String workflowState) {
            this.workflowState = workflowState;
        }

        @Override
        public final Builder workflowState(String workflowState) {
            this.workflowState = workflowState;
            return this;
        }

        @Override
        public final Builder workflowState(WorkflowState workflowState) {
            this.workflowState(workflowState == null ? null : workflowState.toString());
            return this;
        }

        public final Workflow.Builder getWorkflow() {
            return this.workflow != null ? this.workflow.toBuilder() : null;
        }

        public final void setWorkflow(Workflow.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public final String getRecordState() {
            return this.recordState;
        }

        public final void setRecordState(String recordState) {
            this.recordState = recordState;
        }

        @Override
        public final Builder recordState(String recordState) {
            this.recordState = recordState;
            return this;
        }

        @Override
        public final Builder recordState(RecordState recordState) {
            this.recordState(recordState == null ? null : recordState.toString());
            return this;
        }

        public final List<RelatedFinding.Builder> getRelatedFindings() {
            List<RelatedFinding.Builder> result = RelatedFindingListCopier.copyToBuilder(this.relatedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding ... relatedFindings) {
            this.relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder> ... relatedFindings) {
            this.relatedFindings(Stream.of(relatedFindings).map(c -> (RelatedFinding)((RelatedFinding.Builder)RelatedFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Note.Builder getNote() {
            return this.note != null ? this.note.toBuilder() : null;
        }

        public final void setNote(Note.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        @Override
        public final Builder note(Note note) {
            this.note = note;
            return this;
        }

        public final List<Vulnerability.Builder> getVulnerabilities() {
            List<Vulnerability.Builder> result = VulnerabilityListCopier.copyToBuilder(this.vulnerabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilities(Collection<Vulnerability.BuilderImpl> vulnerabilities) {
            this.vulnerabilities = VulnerabilityListCopier.copyFromBuilder(vulnerabilities);
        }

        @Override
        public final Builder vulnerabilities(Collection<Vulnerability> vulnerabilities) {
            this.vulnerabilities = VulnerabilityListCopier.copy(vulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Vulnerability ... vulnerabilities) {
            this.vulnerabilities(Arrays.asList(vulnerabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Consumer<Vulnerability.Builder> ... vulnerabilities) {
            this.vulnerabilities(Stream.of(vulnerabilities).map(c -> (Vulnerability)((Vulnerability.Builder)Vulnerability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PatchSummary.Builder getPatchSummary() {
            return this.patchSummary != null ? this.patchSummary.toBuilder() : null;
        }

        public final void setPatchSummary(PatchSummary.BuilderImpl patchSummary) {
            this.patchSummary = patchSummary != null ? patchSummary.build() : null;
        }

        @Override
        public final Builder patchSummary(PatchSummary patchSummary) {
            this.patchSummary = patchSummary;
            return this;
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final FindingProviderFields.Builder getFindingProviderFields() {
            return this.findingProviderFields != null ? this.findingProviderFields.toBuilder() : null;
        }

        public final void setFindingProviderFields(FindingProviderFields.BuilderImpl findingProviderFields) {
            this.findingProviderFields = findingProviderFields != null ? findingProviderFields.build() : null;
        }

        @Override
        public final Builder findingProviderFields(FindingProviderFields findingProviderFields) {
            this.findingProviderFields = findingProviderFields;
            return this;
        }

        public final Boolean getSample() {
            return this.sample;
        }

        public final void setSample(Boolean sample) {
            this.sample = sample;
        }

        @Override
        public final Builder sample(Boolean sample) {
            this.sample = sample;
            return this;
        }

        public AwsSecurityFinding build() {
            return new AwsSecurityFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsSecurityFinding> {
        public Builder schemaVersion(String var1);

        public Builder id(String var1);

        public Builder productArn(String var1);

        public Builder productName(String var1);

        public Builder companyName(String var1);

        public Builder region(String var1);

        public Builder generatorId(String var1);

        public Builder awsAccountId(String var1);

        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);

        public Builder firstObservedAt(String var1);

        public Builder lastObservedAt(String var1);

        public Builder createdAt(String var1);

        public Builder updatedAt(String var1);

        public Builder severity(Severity var1);

        default public Builder severity(Consumer<Severity.Builder> severity) {
            return this.severity((Severity)((Severity.Builder)Severity.builder().applyMutation(severity)).build());
        }

        public Builder confidence(Integer var1);

        public Builder criticality(Integer var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder remediation(Remediation var1);

        default public Builder remediation(Consumer<Remediation.Builder> remediation) {
            return this.remediation((Remediation)((Remediation.Builder)Remediation.builder().applyMutation(remediation)).build());
        }

        public Builder sourceUrl(String var1);

        public Builder productFields(Map<String, String> var1);

        public Builder userDefinedFields(Map<String, String> var1);

        public Builder malware(Collection<Malware> var1);

        public Builder malware(Malware ... var1);

        public Builder malware(Consumer<Malware.Builder> ... var1);

        public Builder network(Network var1);

        default public Builder network(Consumer<Network.Builder> network) {
            return this.network((Network)((Network.Builder)Network.builder().applyMutation(network)).build());
        }

        public Builder networkPath(Collection<NetworkPathComponent> var1);

        public Builder networkPath(NetworkPathComponent ... var1);

        public Builder networkPath(Consumer<NetworkPathComponent.Builder> ... var1);

        public Builder process(ProcessDetails var1);

        default public Builder process(Consumer<ProcessDetails.Builder> process) {
            return this.process((ProcessDetails)((ProcessDetails.Builder)ProcessDetails.builder().applyMutation(process)).build());
        }

        public Builder threatIntelIndicators(Collection<ThreatIntelIndicator> var1);

        public Builder threatIntelIndicators(ThreatIntelIndicator ... var1);

        public Builder threatIntelIndicators(Consumer<ThreatIntelIndicator.Builder> ... var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder compliance(Compliance var1);

        default public Builder compliance(Consumer<Compliance.Builder> compliance) {
            return this.compliance((Compliance)((Compliance.Builder)Compliance.builder().applyMutation(compliance)).build());
        }

        public Builder verificationState(String var1);

        public Builder verificationState(VerificationState var1);

        public Builder workflowState(String var1);

        public Builder workflowState(WorkflowState var1);

        public Builder workflow(Workflow var1);

        default public Builder workflow(Consumer<Workflow.Builder> workflow) {
            return this.workflow((Workflow)((Workflow.Builder)Workflow.builder().applyMutation(workflow)).build());
        }

        public Builder recordState(String var1);

        public Builder recordState(RecordState var1);

        public Builder relatedFindings(Collection<RelatedFinding> var1);

        public Builder relatedFindings(RelatedFinding ... var1);

        public Builder relatedFindings(Consumer<RelatedFinding.Builder> ... var1);

        public Builder note(Note var1);

        default public Builder note(Consumer<Note.Builder> note) {
            return this.note((Note)((Note.Builder)Note.builder().applyMutation(note)).build());
        }

        public Builder vulnerabilities(Collection<Vulnerability> var1);

        public Builder vulnerabilities(Vulnerability ... var1);

        public Builder vulnerabilities(Consumer<Vulnerability.Builder> ... var1);

        public Builder patchSummary(PatchSummary var1);

        default public Builder patchSummary(Consumer<PatchSummary.Builder> patchSummary) {
            return this.patchSummary((PatchSummary)((PatchSummary.Builder)PatchSummary.builder().applyMutation(patchSummary)).build());
        }

        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder findingProviderFields(FindingProviderFields var1);

        default public Builder findingProviderFields(Consumer<FindingProviderFields.Builder> findingProviderFields) {
            return this.findingProviderFields((FindingProviderFields)((FindingProviderFields.Builder)FindingProviderFields.builder().applyMutation(findingProviderFields)).build());
        }

        public Builder sample(Boolean var1);
    }
}

