/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse;

public class ListTagOptionsIterable
implements SdkIterable<ListTagOptionsResponse> {
    private final ServiceCatalogClient client;
    private final ListTagOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagOptionsIterable(ServiceCatalogClient client, ListTagOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagOptionsResponseFetcher();
    }

    public Iterator<ListTagOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTagOptionsResponseFetcher
    implements SyncPageFetcher<ListTagOptionsResponse> {
        private ListTagOptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.pageToken());
        }

        public ListTagOptionsResponse nextPage(ListTagOptionsResponse previousPage) {
            if (previousPage == null) {
                return ListTagOptionsIterable.this.client.listTagOptions(ListTagOptionsIterable.this.firstRequest);
            }
            return ListTagOptionsIterable.this.client.listTagOptions((ListTagOptionsRequest)((Object)ListTagOptionsIterable.this.firstRequest.toBuilder().pageToken(previousPage.pageToken()).build()));
        }
    }
}

