/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange;

public class ListRequestedServiceQuotaChangeHistoryByQuotaPublisher
implements SdkPublisher<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> {
    private final ServiceQuotasAsyncClient client;
    private final ListRequestedServiceQuotaChangeHistoryByQuotaRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRequestedServiceQuotaChangeHistoryByQuotaPublisher(ServiceQuotasAsyncClient client, ListRequestedServiceQuotaChangeHistoryByQuotaRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRequestedServiceQuotaChangeHistoryByQuotaPublisher(ServiceQuotasAsyncClient client, ListRequestedServiceQuotaChangeHistoryByQuotaRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRequestedServiceQuotaChangeHistoryByQuotaResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRequestedServiceQuotaChangeHistoryByQuotaResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RequestedServiceQuotaChange> requestedQuotas() {
        Function<ListRequestedServiceQuotaChangeHistoryByQuotaResponse, Iterator> getIterator = response -> {
            if (response != null && response.requestedQuotas() != null) {
                return response.requestedQuotas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRequestedServiceQuotaChangeHistoryByQuotaResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRequestedServiceQuotaChangeHistoryByQuotaResponseFetcher
    implements AsyncPageFetcher<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> {
        private ListRequestedServiceQuotaChangeHistoryByQuotaResponseFetcher() {
        }

        public boolean hasNextPage(ListRequestedServiceQuotaChangeHistoryByQuotaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> nextPage(ListRequestedServiceQuotaChangeHistoryByQuotaResponse previousPage) {
            if (previousPage == null) {
                return ListRequestedServiceQuotaChangeHistoryByQuotaPublisher.this.client.listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaPublisher.this.firstRequest);
            }
            return ListRequestedServiceQuotaChangeHistoryByQuotaPublisher.this.client.listRequestedServiceQuotaChangeHistoryByQuota((ListRequestedServiceQuotaChangeHistoryByQuotaRequest)((Object)ListRequestedServiceQuotaChangeHistoryByQuotaPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

