/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AttackStatisticsDataItem;
import software.amazon.awssdk.services.shield.model.AttackStatisticsDataListCopier;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.services.shield.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAttackStatisticsResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, DescribeAttackStatisticsResponse> {
    private static final SdkField<TimeRange> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRange").getter(DescribeAttackStatisticsResponse.getter(DescribeAttackStatisticsResponse::timeRange)).setter(DescribeAttackStatisticsResponse.setter(Builder::timeRange)).constructor(TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()}).build();
    private static final SdkField<List<AttackStatisticsDataItem>> DATA_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataItems").getter(DescribeAttackStatisticsResponse.getter(DescribeAttackStatisticsResponse::dataItems)).setter(DescribeAttackStatisticsResponse.setter(Builder::dataItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttackStatisticsDataItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD, DATA_ITEMS_FIELD));
    private final TimeRange timeRange;
    private final List<AttackStatisticsDataItem> dataItems;

    private DescribeAttackStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.timeRange = builder.timeRange;
        this.dataItems = builder.dataItems;
    }

    public final TimeRange timeRange() {
        return this.timeRange;
    }

    public final boolean hasDataItems() {
        return this.dataItems != null && !(this.dataItems instanceof SdkAutoConstructList);
    }

    public final List<AttackStatisticsDataItem> dataItems() {
        return this.dataItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataItems() ? this.dataItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttackStatisticsResponse)) {
            return false;
        }
        DescribeAttackStatisticsResponse other = (DescribeAttackStatisticsResponse)((Object)obj);
        return Objects.equals(this.timeRange(), other.timeRange()) && this.hasDataItems() == other.hasDataItems() && Objects.equals(this.dataItems(), other.dataItems());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAttackStatisticsResponse").add("TimeRange", (Object)this.timeRange()).add("DataItems", this.hasDataItems() ? this.dataItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRange()));
            }
            case "DataItems": {
                return Optional.ofNullable(clazz.cast(this.dataItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAttackStatisticsResponse, T> g) {
        return obj -> g.apply((DescribeAttackStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private TimeRange timeRange;
        private List<AttackStatisticsDataItem> dataItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttackStatisticsResponse model) {
            super(model);
            this.timeRange(model.timeRange);
            this.dataItems(model.dataItems);
        }

        public final TimeRange.Builder getTimeRange() {
            return this.timeRange != null ? this.timeRange.toBuilder() : null;
        }

        public final void setTimeRange(TimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final List<AttackStatisticsDataItem.Builder> getDataItems() {
            List<AttackStatisticsDataItem.Builder> result = AttackStatisticsDataListCopier.copyToBuilder(this.dataItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataItems(Collection<AttackStatisticsDataItem.BuilderImpl> dataItems) {
            this.dataItems = AttackStatisticsDataListCopier.copyFromBuilder(dataItems);
        }

        @Override
        public final Builder dataItems(Collection<AttackStatisticsDataItem> dataItems) {
            this.dataItems = AttackStatisticsDataListCopier.copy(dataItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(AttackStatisticsDataItem ... dataItems) {
            this.dataItems(Arrays.asList(dataItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(Consumer<AttackStatisticsDataItem.Builder> ... dataItems) {
            this.dataItems(Stream.of(dataItems).map(c -> (AttackStatisticsDataItem)((AttackStatisticsDataItem.Builder)AttackStatisticsDataItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAttackStatisticsResponse build() {
            return new DescribeAttackStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAttackStatisticsResponse> {
        public Builder timeRange(TimeRange var1);

        default public Builder timeRange(Consumer<TimeRange.Builder> timeRange) {
            return this.timeRange((TimeRange)((TimeRange.Builder)TimeRange.builder().applyMutation(timeRange)).build());
        }

        public Builder dataItems(Collection<AttackStatisticsDataItem> var1);

        public Builder dataItems(AttackStatisticsDataItem ... var1);

        public Builder dataItems(Consumer<AttackStatisticsDataItem.Builder> ... var1);
    }
}

