/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.model.Contact;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse;

public class ListContactsIterable
implements SdkIterable<ListContactsResponse> {
    private final SsmContactsClient client;
    private final ListContactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactsIterable(SsmContactsClient client, ListContactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListContactsResponseFetcher();
    }

    public Iterator<ListContactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Contact> contacts() {
        Function<ListContactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contacts() != null) {
                return response.contacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactsResponseFetcher
    implements SyncPageFetcher<ListContactsResponse> {
        private ListContactsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactsResponse nextPage(ListContactsResponse previousPage) {
            if (previousPage == null) {
                return ListContactsIterable.this.client.listContacts(ListContactsIterable.this.firstRequest);
            }
            return ListContactsIterable.this.client.listContacts((ListContactsRequest)((Object)ListContactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

