/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordSummary;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsResponse;

public class ListIncidentRecordsPublisher
implements SdkPublisher<ListIncidentRecordsResponse> {
    private final SsmIncidentsAsyncClient client;
    private final ListIncidentRecordsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIncidentRecordsPublisher(SsmIncidentsAsyncClient client, ListIncidentRecordsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIncidentRecordsPublisher(SsmIncidentsAsyncClient client, ListIncidentRecordsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIncidentRecordsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIncidentRecordsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IncidentRecordSummary> incidentRecordSummaries() {
        Function<ListIncidentRecordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.incidentRecordSummaries() != null) {
                return response.incidentRecordSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIncidentRecordsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIncidentRecordsResponseFetcher
    implements AsyncPageFetcher<ListIncidentRecordsResponse> {
        private ListIncidentRecordsResponseFetcher() {
        }

        public boolean hasNextPage(ListIncidentRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIncidentRecordsResponse> nextPage(ListIncidentRecordsResponse previousPage) {
            if (previousPage == null) {
                return ListIncidentRecordsPublisher.this.client.listIncidentRecords(ListIncidentRecordsPublisher.this.firstRequest);
            }
            return ListIncidentRecordsPublisher.this.client.listIncidentRecords((ListIncidentRecordsRequest)((Object)ListIncidentRecordsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

