/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeArchive;

public class DescribeTapeArchivesPublisher
implements SdkPublisher<DescribeTapeArchivesResponse> {
    private final StorageGatewayAsyncClient client;
    private final DescribeTapeArchivesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTapeArchivesPublisher(StorageGatewayAsyncClient client, DescribeTapeArchivesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTapeArchivesPublisher(StorageGatewayAsyncClient client, DescribeTapeArchivesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTapeArchivesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTapeArchivesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TapeArchive> tapeArchives() {
        Function<DescribeTapeArchivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapeArchives() != null) {
                return response.tapeArchives().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTapeArchivesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTapeArchivesResponseFetcher
    implements AsyncPageFetcher<DescribeTapeArchivesResponse> {
        private DescribeTapeArchivesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTapeArchivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeTapeArchivesResponse> nextPage(DescribeTapeArchivesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTapeArchivesPublisher.this.client.describeTapeArchives(DescribeTapeArchivesPublisher.this.firstRequest);
            }
            return DescribeTapeArchivesPublisher.this.client.describeTapeArchives((DescribeTapeArchivesRequest)((Object)DescribeTapeArchivesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

