/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.User;

public class DescribeUsersIterable
implements SdkIterable<DescribeUsersResponse> {
    private final WorkDocsClient client;
    private final DescribeUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeUsersIterable(WorkDocsClient client, DescribeUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeUsersResponseFetcher();
    }

    public Iterator<DescribeUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<User> users() {
        Function<DescribeUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeUsersResponseFetcher
    implements SyncPageFetcher<DescribeUsersResponse> {
        private DescribeUsersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeUsersResponse nextPage(DescribeUsersResponse previousPage) {
            if (previousPage == null) {
                return DescribeUsersIterable.this.client.describeUsers(DescribeUsersIterable.this.firstRequest);
            }
            return DescribeUsersIterable.this.client.describeUsers((DescribeUsersRequest)((Object)DescribeUsersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

