/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetTraceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetTraceGraphResponse;
import software.amazon.awssdk.services.xray.model.Service;

public class GetTraceGraphPublisher
implements SdkPublisher<GetTraceGraphResponse> {
    private final XRayAsyncClient client;
    private final GetTraceGraphRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTraceGraphPublisher(XRayAsyncClient client, GetTraceGraphRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTraceGraphPublisher(XRayAsyncClient client, GetTraceGraphRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTraceGraphResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTraceGraphResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Service> services() {
        Function<GetTraceGraphResponse, Iterator> getIterator = response -> {
            if (response != null && response.services() != null) {
                return response.services().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTraceGraphResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetTraceGraphResponseFetcher
    implements AsyncPageFetcher<GetTraceGraphResponse> {
        private GetTraceGraphResponseFetcher() {
        }

        public boolean hasNextPage(GetTraceGraphResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTraceGraphResponse> nextPage(GetTraceGraphResponse previousPage) {
            if (previousPage == null) {
                return GetTraceGraphPublisher.this.client.getTraceGraph(GetTraceGraphPublisher.this.firstRequest);
            }
            return GetTraceGraphPublisher.this.client.getTraceGraph((GetTraceGraphRequest)((Object)GetTraceGraphPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

