/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.actuate.endpoint;

import com.alibaba.boot.dubbo.util.DubboUtils;
import com.alibaba.dubbo.common.Version;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.dubbo", ignoreUnknownFields=false)
public class DubboEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    public static final String DUBBO_SHUTDOWN_ENDPOINT_URI = "/shutdown";
    public static final String DUBBO_CONFIGS_ENDPOINT_URI = "/configs";
    public static final String DUBBO_SERVICES_ENDPOINT_URI = "/services";
    public static final String DUBBO_REFERENCES_ENDPOINT_URI = "/references";
    public static final String DUBBO_PROPERTIES_ENDPOINT_URI = "/properties";

    public DubboEndpoint() {
        super("dubbo", true, false);
    }

    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> metaData = new LinkedHashMap<String, Object>();
        metaData.put("timestamp", System.currentTimeMillis());
        LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
        versions.put("dubbo-spring-boot", Version.getVersion(DubboUtils.class, (String)"1.0.0"));
        versions.put("dubbo", Version.getVersion());
        LinkedHashMap<String, String> urls = new LinkedHashMap<String, String>();
        urls.put("dubbo", "https://github.com/alibaba/dubbo");
        urls.put("google-group", "http://groups.google.com/group/dubbo");
        urls.put("github", "https://github.com/dubbo/dubbo-spring-boot-project");
        urls.put("issues", "https://github.com/dubbo/dubbo-spring-boot-project/issues");
        urls.put("git", "https://github.com/dubbo/dubbo-spring-boot-project.git");
        LinkedHashMap<String, String> endpoints = new LinkedHashMap<String, String>();
        endpoints.put("shutdown", DUBBO_SHUTDOWN_ENDPOINT_URI);
        endpoints.put("configs", DUBBO_CONFIGS_ENDPOINT_URI);
        endpoints.put("services", DUBBO_SERVICES_ENDPOINT_URI);
        endpoints.put("references", DUBBO_REFERENCES_ENDPOINT_URI);
        endpoints.put("properties", DUBBO_PROPERTIES_ENDPOINT_URI);
        metaData.put("versions", versions);
        metaData.put("urls", urls);
        metaData.put("endpoints", endpoints);
        return metaData;
    }
}

