/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.ClassNameWildcardCompiler;

public final class ModuleKey {
    private final String moduleType;
    private final String moduleName;

    public ModuleKey(String moduleType, String moduleName) {
        this.moduleType = Assert.assertNotNull(StringUtil.trimToNull(moduleType), "moduleType", new Object[0]);
        this.moduleName = Assert.assertNotNull(this.normalizeModuleName(moduleName), "moduleName", new Object[0]);
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    private String normalizeModuleName(String moduleName) {
        if (StringUtil.isEmpty(moduleName = StringUtil.toCamelCase(ClassNameWildcardCompiler.normalizeClassName(moduleName)))) {
            return null;
        }
        int index = moduleName.lastIndexOf(".") + 1;
        if (index < moduleName.length() && Character.isLowerCase(moduleName.charAt(index))) {
            StringBuilder buf = new StringBuilder(moduleName);
            buf.setCharAt(index, Character.toUpperCase(moduleName.charAt(index)));
            moduleName = buf.toString();
        }
        return moduleName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (this.moduleType == null ? 0 : this.moduleType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleKey other = (ModuleKey)obj;
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        return !(this.moduleType == null ? other.moduleType != null : !this.moduleType.equals(other.moduleType));
    }

    public String toString() {
        return this.moduleType + ":" + this.moduleName;
    }
}

