/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.io;

import com.alibaba.citrus.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArray {
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public ByteArray(byte[] bytes) {
        this(bytes, 0, Integer.MIN_VALUE);
    }

    public ByteArray(byte[] bytes, int offset, int length) {
        Assert.assertNotNull(bytes, "bytes", new Object[0]);
        Assert.assertTrue(offset >= 0, "offset", offset);
        if (length == Integer.MIN_VALUE) {
            length = bytes.length - offset;
        }
        Assert.assertTrue(length >= 0 && length <= bytes.length - offset, "length", new Object[0]);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] toByteArray() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, copy, 0, this.length);
        return copy;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes, this.offset, this.length);
    }

    public String toString() {
        return "byte[" + this.length + "]";
    }
}

