/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.endpoint;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;

public class NacosDiscoveryEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryEndpoint.class);
    private NacosDiscoveryProperties nacosDiscoveryProperties;

    public NacosDiscoveryEndpoint(NacosDiscoveryProperties nacosDiscoveryProperties) {
        super("nacos_discovery", false);
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("NacosDiscoveryProperties", this.nacosDiscoveryProperties);
        NamingService namingService = this.nacosDiscoveryProperties.namingServiceInstance();
        List subscribe = Collections.emptyList();
        try {
            subscribe = namingService.getSubscribeServices();
        }
        catch (Exception e) {
            log.error("get subscribe services from nacos fail,", (Throwable)e);
        }
        result.put("subscribe", subscribe);
        return result;
    }
}

