/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DefaultDubboFallback;
import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallback;
import com.alibaba.csp.sentinel.adapter.dubbo.origin.DefaultDubboOriginParser;
import com.alibaba.csp.sentinel.adapter.dubbo.origin.DubboOriginParser;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;

public final class DubboAdapterGlobalConfig {
    private static final String TRUE_STR = "true";
    public static final String DUBBO_RES_NAME_WITH_PREFIX_KEY = "csp.sentinel.dubbo.resource.use.prefix";
    public static final String DUBBO_PROVIDER_RES_NAME_PREFIX_KEY = "csp.sentinel.dubbo.resource.provider.prefix";
    public static final String DUBBO_CONSUMER_RES_NAME_PREFIX_KEY = "csp.sentinel.dubbo.resource.consumer.prefix";
    private static final String DEFAULT_DUBBO_PROVIDER_PREFIX = "dubbo:provider:";
    private static final String DEFAULT_DUBBO_CONSUMER_PREFIX = "dubbo:consumer:";
    private static volatile DubboFallback consumerFallback = new DefaultDubboFallback();
    private static volatile DubboFallback providerFallback = new DefaultDubboFallback();
    private static volatile DubboOriginParser originParser = new DefaultDubboOriginParser();

    public static boolean isUsePrefix() {
        return TRUE_STR.equalsIgnoreCase(SentinelConfig.getConfig((String)DUBBO_RES_NAME_WITH_PREFIX_KEY));
    }

    public static String getDubboProviderPrefix() {
        if (DubboAdapterGlobalConfig.isUsePrefix()) {
            String config = SentinelConfig.getConfig((String)DUBBO_PROVIDER_RES_NAME_PREFIX_KEY);
            return StringUtil.isNotBlank((String)config) ? config : DEFAULT_DUBBO_PROVIDER_PREFIX;
        }
        return null;
    }

    public static String getDubboConsumerPrefix() {
        if (DubboAdapterGlobalConfig.isUsePrefix()) {
            String config = SentinelConfig.getConfig((String)DUBBO_CONSUMER_RES_NAME_PREFIX_KEY);
            return StringUtil.isNotBlank((String)config) ? config : DEFAULT_DUBBO_CONSUMER_PREFIX;
        }
        return null;
    }

    public static DubboFallback getConsumerFallback() {
        return consumerFallback;
    }

    public static void setConsumerFallback(DubboFallback consumerFallback) {
        AssertUtil.notNull((Object)consumerFallback, (String)"consumerFallback cannot be null");
        DubboAdapterGlobalConfig.consumerFallback = consumerFallback;
    }

    public static DubboFallback getProviderFallback() {
        return providerFallback;
    }

    public static void setProviderFallback(DubboFallback providerFallback) {
        AssertUtil.notNull((Object)providerFallback, (String)"providerFallback cannot be null");
        DubboAdapterGlobalConfig.providerFallback = providerFallback;
    }

    public static DubboOriginParser getOriginParser() {
        return originParser;
    }

    public static void setOriginParser(DubboOriginParser originParser) {
        AssertUtil.notNull((Object)originParser, (String)"originParser cannot be null");
        DubboAdapterGlobalConfig.originParser = originParser;
    }

    private DubboAdapterGlobalConfig() {
    }
}

