/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class DB2SelectParser
extends SQLSelectParser {
    public DB2SelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public DB2SelectParser(String sql) {
        this(new DB2ExprParser(sql));
    }

    protected SQLExprParser createExprParser() {
        return new DB2ExprParser(this.lexer);
    }

    @Override
    public SQLSelectQuery query() {
        DB2SelectQueryBlock queryBlock;
        block22: {
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLSelectQuery select = this.query();
                this.accept(Token.RPAREN);
                return this.queryRest(select);
            }
            this.accept(Token.SELECT);
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            queryBlock = new DB2SelectQueryBlock();
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UNIQUE) {
                queryBlock.setDistionOption(3);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
            this.parseFrom(queryBlock);
            this.parseWhere(queryBlock);
            this.parseGroupBy(queryBlock);
            if (this.lexer.token() == Token.ORDER) {
                SQLOrderBy orderBy = this.parseOrderBy();
                queryBlock.setOrderBy(orderBy);
            }
            while (true) {
                if (this.lexer.token() == Token.FETCH) {
                    this.lexer.nextToken();
                    this.accept(Token.FIRST);
                    SQLExpr first = this.exprParser.primary();
                    queryBlock.setFirst(first);
                    if (this.identifierEquals("ROW") || this.identifierEquals("ROWS")) {
                        this.lexer.nextToken();
                    }
                    this.accept(Token.ONLY);
                    continue;
                }
                if (this.lexer.token() != Token.WITH) break;
                this.lexer.nextToken();
                if (this.identifierEquals("RR")) {
                    queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.RR);
                } else if (this.identifierEquals("RS")) {
                    queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.RS);
                } else if (this.identifierEquals("CS")) {
                    queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.CS);
                } else if (this.identifierEquals("UR")) {
                    queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.UR);
                } else {
                    throw new ParserException("TODO");
                }
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                this.acceptIdentifier("READ");
                this.accept(Token.ONLY);
                queryBlock.setForReadOnly(true);
            }
            if (this.lexer.token() != Token.OPTIMIZE) break block22;
            this.lexer.nextToken();
            this.accept(Token.FOR);
            queryBlock.setOptimizeFor(this.expr());
            if (this.identifierEquals("ROW")) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("ROWS");
            }
        }
        return this.queryRest(queryBlock);
    }
}

