/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLExprUtils;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAnalyzePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCheckPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCoalescePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableConvertCharSet;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDiscardPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableImportPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableOptimizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableReOrganizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRebuildPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRepairPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTruncatePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTypeStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCloseStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSynonymStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTypeStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDumpStatement;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLOpenStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExpr;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsValuesTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDbLinkExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleExpr;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitorAdapter;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaStatVisitor
extends SQLASTVisitorAdapter {
    protected SchemaRepository repository;
    protected final HashMap<TableStat.Name, TableStat> tableStats = new LinkedHashMap<TableStat.Name, TableStat>();
    protected final Map<Long, TableStat.Column> columns = new LinkedHashMap<Long, TableStat.Column>();
    protected final List<TableStat.Condition> conditions = new ArrayList<TableStat.Condition>();
    protected final Set<TableStat.Relationship> relationships = new LinkedHashSet<TableStat.Relationship>();
    protected final List<TableStat.Column> orderByColumns = new ArrayList<TableStat.Column>();
    protected final Set<TableStat.Column> groupByColumns = new LinkedHashSet<TableStat.Column>();
    protected final List<SQLAggregateExpr> aggregateFunctions = new ArrayList<SQLAggregateExpr>();
    protected final List<SQLMethodInvokeExpr> functions = new ArrayList<SQLMethodInvokeExpr>(2);
    private List<Object> parameters;
    private TableStat.Mode mode;
    protected String dbType;

    public SchemaStatVisitor() {
        this((String)null);
    }

    public SchemaStatVisitor(String dbType) {
        this(new SchemaRepository(dbType), new ArrayList<Object>());
        this.dbType = dbType;
    }

    public SchemaRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SchemaRepository repository) {
        this.repository = repository;
    }

    public SchemaStatVisitor(List<Object> parameters) {
        this((String)null, parameters);
    }

    public SchemaStatVisitor(String dbType, List<Object> parameters) {
        this(new SchemaRepository(dbType), parameters);
        this.parameters = parameters;
    }

    public SchemaStatVisitor(SchemaRepository repository, List<Object> parameters) {
        String dbType;
        this.repository = repository;
        this.parameters = parameters;
        if (repository != null && (dbType = repository.getDbType()) != null && this.dbType == null) {
            this.dbType = dbType;
        }
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public TableStat getTableStat(String tableName) {
        TableStat.Name tableNameObj = new TableStat.Name(tableName = this.handleName(tableName));
        TableStat stat = this.tableStats.get(tableNameObj);
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(tableName), stat);
        }
        return stat;
    }

    public TableStat getTableStat(SQLName tableName) {
        String strName = tableName.toString();
        long hashCode64 = tableName.hashCode64();
        if (hashCode64 == FnvHash.Constants.DUAL) {
            return null;
        }
        TableStat.Name tableNameObj = new TableStat.Name(strName, hashCode64);
        TableStat stat = this.tableStats.get(tableNameObj);
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(strName, hashCode64), stat);
        }
        return stat;
    }

    protected TableStat.Column addColumn(String tableName, String columnName) {
        TableStat.Column column = this.getColumn(tableName, columnName);
        if (column == null && columnName != null) {
            column = new TableStat.Column(tableName, columnName);
            this.columns.put(column.hashCode64(), column);
        }
        return column;
    }

    protected TableStat.Column addColumn(SQLName table, String columnName) {
        long tableHashCode64;
        String tableName = table.toString();
        long basic = tableHashCode64 = table.hashCode64();
        basic ^= 0x2EL;
        long columnHashCode64 = FnvHash.hashCode64(basic *= 1099511628211L, columnName);
        TableStat.Column column = this.columns.get(columnHashCode64);
        if (column == null && columnName != null) {
            column = new TableStat.Column(tableName, columnName, columnHashCode64);
            this.columns.put(columnHashCode64, column);
        }
        return column;
    }

    private String handleName(String ident) {
        int len = ident.length();
        if (ident.charAt(0) == '[' && ident.charAt(len - 1) == ']') {
            ident = ident.substring(1, len - 1);
        } else {
            boolean flag0 = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            for (int i = 0; i < len; ++i) {
                char ch = ident.charAt(i);
                if (ch == '\"') {
                    flag0 = true;
                    continue;
                }
                if (ch == '`') {
                    flag1 = true;
                    continue;
                }
                if (ch == ' ') {
                    flag2 = true;
                    continue;
                }
                if (ch != '\'') continue;
                flag3 = true;
            }
            if (flag0) {
                ident = ident.replaceAll("\"", "");
            }
            if (flag1) {
                ident = ident.replaceAll("`", "");
            }
            if (flag2) {
                ident = ident.replaceAll(" ", "");
            }
            if (flag3) {
                ident = ident.replaceAll("'", "");
            }
        }
        return ident;
    }

    protected TableStat.Mode getMode() {
        return this.mode;
    }

    protected void setModeOrigin(SQLObject x) {
        TableStat.Mode originalMode;
        this.mode = originalMode = (TableStat.Mode)((Object)x.getAttribute("_original_use_mode"));
    }

    protected TableStat.Mode setMode(SQLObject x, TableStat.Mode mode) {
        TableStat.Mode oldMode = this.mode;
        x.putAttribute("_original_use_mode", (Object)oldMode);
        this.mode = mode;
        return oldMode;
    }

    private boolean visitOrderBy(SQLIdentifierExpr x) {
        String tableName;
        block14: {
            block16: {
                SQLName tableExpr;
                block17: {
                    SQLTableSource tableSource;
                    block12: {
                        SQLMethodInvokeExpr methodInvokeExpr;
                        SQLExpr expr;
                        block15: {
                            block13: {
                                tableSource = x.getResolvedTableSource();
                                tableName = null;
                                if (!(tableSource instanceof SQLExprTableSource)) break block12;
                                expr = ((SQLExprTableSource)tableSource).getExpr();
                                if (!(expr instanceof SQLIdentifierExpr)) break block13;
                                SQLIdentifierExpr table = (SQLIdentifierExpr)expr;
                                tableName = table.getName();
                                break block14;
                            }
                            if (!(expr instanceof SQLPropertyExpr)) break block15;
                            SQLPropertyExpr table = (SQLPropertyExpr)expr;
                            tableName = table.toString();
                            break block14;
                        }
                        if (!(expr instanceof SQLMethodInvokeExpr) || !"table".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)expr).getMethodName()) || methodInvokeExpr.getParameters().size() != 1 || !(methodInvokeExpr.getParameters().get(0) instanceof SQLName)) break block14;
                        SQLName table = (SQLName)methodInvokeExpr.getParameters().get(0);
                        if (table instanceof SQLPropertyExpr) {
                            SQLExpr resolveExpr;
                            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)table;
                            SQLIdentifierExpr owner = (SQLIdentifierExpr)propertyExpr.getOwner();
                            if (propertyExpr.getResolvedTableSource() != null && propertyExpr.getResolvedTableSource() instanceof SQLExprTableSource && (resolveExpr = ((SQLExprTableSource)propertyExpr.getResolvedTableSource()).getExpr()) instanceof SQLName) {
                                tableName = resolveExpr.toString() + "." + propertyExpr.getName();
                            }
                        }
                        if (tableName != null) break block14;
                        tableName = table.toString();
                        break block14;
                    }
                    if (tableSource instanceof SQLWithSubqueryClause.Entry) {
                        return false;
                    }
                    if (!(tableSource instanceof SQLSubqueryTableSource)) break block16;
                    SQLSelectQueryBlock queryBlock = ((SQLSubqueryTableSource)tableSource).getSelect().getQueryBlock();
                    if (queryBlock == null) {
                        return false;
                    }
                    SQLSelectItem selectItem = queryBlock.findSelectItem(x.nameHashCode64());
                    if (selectItem == null) {
                        return false;
                    }
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    SQLTableSource columnTableSource = null;
                    if (selectItemExpr instanceof SQLIdentifierExpr) {
                        columnTableSource = ((SQLIdentifierExpr)selectItemExpr).getResolvedTableSource();
                    } else if (selectItemExpr instanceof SQLPropertyExpr) {
                        columnTableSource = ((SQLPropertyExpr)selectItemExpr).getResolvedTableSource();
                    }
                    if (!(columnTableSource instanceof SQLExprTableSource) || !(((SQLExprTableSource)columnTableSource).getExpr() instanceof SQLName)) break block14;
                    tableExpr = (SQLName)((SQLExprTableSource)columnTableSource).getExpr();
                    if (!(tableExpr instanceof SQLIdentifierExpr)) break block17;
                    tableName = ((SQLIdentifierExpr)tableExpr).normalizedName();
                    break block14;
                }
                if (!(tableExpr instanceof SQLPropertyExpr)) break block14;
                tableName = ((SQLPropertyExpr)tableExpr).normalizedName();
                break block14;
            }
            boolean skip = false;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                    if (!(from instanceof OdpsValuesTableSource)) continue;
                    skip = true;
                    break;
                }
                if (parent instanceof SQLSelectQuery) break;
            }
        }
        String identName = x.getName();
        if (tableName != null) {
            this.orderByAddColumn(tableName, identName, x);
        } else {
            this.orderByAddColumn("UNKOWN", identName, x);
        }
        return false;
    }

    private boolean visitOrderBy(SQLPropertyExpr x) {
        SQLExpr tableSourceExpr;
        if (this.isSubQueryOrParamOrVariant(x)) {
            return false;
        }
        String owner = null;
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource instanceof SQLExprTableSource && (tableSourceExpr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLName) {
            owner = tableSourceExpr.toString();
        }
        if (owner == null && x.getOwner() instanceof SQLIdentifierExpr) {
            owner = ((SQLIdentifierExpr)x.getOwner()).getName();
        }
        if (owner == null) {
            return false;
        }
        if (owner != null) {
            this.orderByAddColumn(owner, x.getName(), x);
        }
        return false;
    }

    private void orderByAddColumn(String table, String columnName, SQLObject expr) {
        TableStat.Column column = new TableStat.Column(table, columnName);
        SQLObject parent = expr.getParent();
        if (parent instanceof SQLSelectOrderByItem) {
            SQLOrderingSpecification type = ((SQLSelectOrderByItem)parent).getType();
            column.getAttributes().put("orderBy.type", (Object)type);
        }
        this.orderByColumns.add(column);
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        SQLASTVisitor orderByVisitor = this.createOrderByVisitor(x);
        SQLSelectQueryBlock query = null;
        if (x.getParent() instanceof SQLSelectQueryBlock) {
            query = (SQLSelectQueryBlock)x.getParent();
        }
        if (query != null) {
            for (SQLSelectOrderByItem item : x.getItems()) {
                SQLExpr expr = item.getExpr();
                if (expr instanceof SQLIntegerExpr) {
                    int intValue = ((SQLIntegerExpr)expr).getNumber().intValue() - 1;
                    if (intValue >= query.getSelectList().size()) continue;
                    SQLSelectItem selectItem = query.getSelectList().get(intValue);
                    selectItem.getExpr().accept(orderByVisitor);
                    continue;
                }
                if (!(expr instanceof MySqlExpr) && !(expr instanceof OracleExpr)) continue;
            }
        }
        x.accept(orderByVisitor);
        for (SQLSelectOrderByItem orderByItem : x.getItems()) {
            this.statExpr(orderByItem.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(SQLOver x) {
        SQLName of = x.getOf();
        SQLOrderBy orderBy = x.getOrderBy();
        List<SQLExpr> partitionBy = x.getPartitionBy();
        if (of == null && orderBy != null) {
            orderBy.accept(this);
        }
        if (partitionBy != null) {
            for (SQLExpr expr : partitionBy) {
                expr.accept(this);
            }
        }
        return false;
    }

    protected SQLASTVisitor createOrderByVisitor(SQLOrderBy x) {
        SQLASTVisitorAdapter orderByVisitor = "mysql".equals(this.dbType) ? new MySqlOrderByStatVisitor(x) : ("postgresql".equals(this.dbType) ? new PGOrderByStatVisitor(x) : ("oracle".equals(this.dbType) ? new OracleOrderByStatVisitor(x) : new OrderByStatVisitor(x)));
        return orderByVisitor;
    }

    public Set<TableStat.Relationship> getRelationships() {
        return this.relationships;
    }

    public List<TableStat.Column> getOrderByColumns() {
        return this.orderByColumns;
    }

    public Set<TableStat.Column> getGroupByColumns() {
        return this.groupByColumns;
    }

    public List<TableStat.Condition> getConditions() {
        return this.conditions;
    }

    public List<SQLAggregateExpr> getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        SQLObject parent = x.getParent();
        SQLExpr test = x.getTestExpr();
        SQLExpr begin = x.getBeginExpr();
        SQLExpr end = x.getEndExpr();
        this.statExpr(test);
        this.statExpr(begin);
        this.statExpr(end);
        this.handleCondition(test, "BETWEEN", begin, end);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SQLObject parent = x.getParent();
        if (parent instanceof SQLIfStatement) {
            return true;
        }
        SQLBinaryOperator op = x.getOperator();
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        switch (op) {
            case Equality: 
            case NotEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case LessThan: 
            case LessThanOrGreater: 
            case LessThanOrEqual: 
            case LessThanOrEqualOrGreaterThan: 
            case Like: 
            case NotLike: 
            case Is: 
            case IsNot: {
                this.handleCondition(left, x.getOperator().name, right);
                this.handleCondition(right, x.getOperator().name, left);
                this.handleRelationship(left, x.getOperator().name, right);
                break;
            }
            case BooleanOr: {
                List<SQLExpr> list = SQLBinaryOpExpr.split(x, op);
                for (SQLExpr item : list) {
                    if (item instanceof SQLBinaryOpExpr) {
                        this.visit((SQLBinaryOpExpr)item);
                        continue;
                    }
                    item.accept(this);
                }
                return false;
            }
            case Modulus: {
                long hashCode64;
                if (!(right instanceof SQLIdentifierExpr) || (hashCode64 = ((SQLIdentifierExpr)right).hashCode64()) != FnvHash.Constants.ISOPEN) break;
                left.accept(this);
                return false;
            }
        }
        this.statExpr(left);
        this.statExpr(right);
        return false;
    }

    protected void handleRelationship(SQLExpr left, String operator, SQLExpr right) {
        TableStat.Column leftColumn = this.getColumn(left);
        if (leftColumn == null) {
            return;
        }
        TableStat.Column rightColumn = this.getColumn(right);
        if (rightColumn == null) {
            return;
        }
        TableStat.Relationship relationship = new TableStat.Relationship(leftColumn, rightColumn, operator);
        this.relationships.add(relationship);
    }

    protected void handleCondition(SQLExpr expr, String operator, List<SQLExpr> values) {
        this.handleCondition(expr, operator, values.toArray(new SQLExpr[values.size()]));
    }

    protected void handleCondition(SQLExpr expr, String operator, SQLExpr ... valueExprs) {
        TableStat.Column column;
        if (expr instanceof SQLCastExpr) {
            expr = ((SQLCastExpr)expr).getExpr();
        }
        if ((column = this.getColumn(expr)) == null) {
            return;
        }
        TableStat.Condition condition = null;
        for (TableStat.Condition item : this.getConditions()) {
            if (!item.getColumn().equals(column) || !item.getOperator().equals(operator)) continue;
            condition = item;
            break;
        }
        if (condition == null) {
            condition = new TableStat.Condition(column, operator);
            this.conditions.add(condition);
        }
        for (SQLExpr item : valueExprs) {
            Object value;
            TableStat.Column valueColumn = this.getColumn(item);
            if (valueColumn != null) continue;
            if (item instanceof SQLMethodInvokeExpr) {
                value = item.toString();
            } else {
                value = SQLEvalVisitorUtils.eval(this.dbType, (SQLObject)item, this.parameters, false);
                if (value == SQLEvalVisitor.EVAL_VALUE_NULL) {
                    value = null;
                }
            }
            condition.addValue(value);
        }
    }

    public String getDbType() {
        return this.dbType;
    }

    protected TableStat.Column getColumn(SQLExpr expr) {
        SQLExpr original = expr;
        if ((expr = this.unwrapExpr(expr)) instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
            SQLExpr owner = propertyExpr.getOwner();
            String column = propertyExpr.getName();
            if (owner instanceof SQLName) {
                SQLExpr tableSourceExpr;
                SQLName table = (SQLName)owner;
                SQLObject resolvedOwnerObject = propertyExpr.getResolvedOwnerObject();
                if (resolvedOwnerObject instanceof SQLSubqueryTableSource || resolvedOwnerObject instanceof SQLCreateProcedureStatement || resolvedOwnerObject instanceof SQLCreateFunctionStatement) {
                    table = null;
                }
                if (resolvedOwnerObject instanceof SQLExprTableSource && (tableSourceExpr = ((SQLExprTableSource)resolvedOwnerObject).getExpr()) instanceof SQLName) {
                    table = (SQLName)tableSourceExpr;
                }
                if (table != null) {
                    long tableHashCode64;
                    long basic = tableHashCode64 = table.hashCode64();
                    basic ^= 0x2EL;
                    long columnHashCode64 = FnvHash.hashCode64(basic *= 1099511628211L, column);
                    return new TableStat.Column(table.toString(), column, columnHashCode64);
                }
            }
            return null;
        }
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            if (identifierExpr.getResolvedParameter() != null) {
                return null;
            }
            if (identifierExpr.getResolvedTableSource() instanceof SQLSubqueryTableSource) {
                return null;
            }
            if (identifierExpr.getResolvedDeclareItem() != null || identifierExpr.getResolvedParameter() != null) {
                return null;
            }
            String column = identifierExpr.getName();
            SQLName table = null;
            SQLTableSource tableSource = identifierExpr.getResolvedTableSource();
            if (tableSource instanceof SQLExprTableSource) {
                SQLExpr tableSourceExpr = ((SQLExprTableSource)tableSource).getExpr();
                if (tableSourceExpr != null && !(tableSourceExpr instanceof SQLName)) {
                    tableSourceExpr = this.unwrapExpr(tableSourceExpr);
                }
                if (tableSourceExpr instanceof SQLName) {
                    table = (SQLName)tableSourceExpr;
                }
            }
            if (table != null) {
                long tableHashCode64;
                long basic = tableHashCode64 = table.hashCode64();
                basic ^= 0x2EL;
                long columnHashCode64 = FnvHash.hashCode64(basic *= 1099511628211L, column);
                return new TableStat.Column(table.toString(), column, columnHashCode64);
            }
            return new TableStat.Column("UNKNOWN", column);
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
            List<SQLExpr> arguments = methodInvokeExpr.getParameters();
            long nameHash = methodInvokeExpr.methodNameHashCode64();
            if (nameHash == FnvHash.Constants.DATE_FORMAT && arguments.size() == 2 && arguments.get(0) instanceof SQLName && arguments.get(1) instanceof SQLCharExpr) {
                return this.getColumn(arguments.get(0));
            }
        }
        return null;
    }

    private SQLExpr unwrapExpr(SQLExpr expr) {
        block16: {
            SQLExpr tableSourceExpr;
            SQLPropertyExpr propertyExpr;
            SQLExpr original = expr;
            while (true) {
                SQLExprTableSource exprTableSource;
                SQLMethodInvokeExpr methodInvokeExp;
                if (expr instanceof SQLMethodInvokeExpr && (methodInvokeExp = (SQLMethodInvokeExpr)expr).getParameters().size() == 1) {
                    SQLExpr firstExpr;
                    expr = firstExpr = methodInvokeExp.getParameters().get(0);
                    continue;
                }
                if (expr instanceof SQLCastExpr) {
                    expr = ((SQLCastExpr)expr).getExpr();
                    continue;
                }
                if (!(expr instanceof SQLPropertyExpr)) break block16;
                propertyExpr = (SQLPropertyExpr)expr;
                SQLTableSource resolvedTableSource = propertyExpr.getResolvedTableSource();
                if (resolvedTableSource instanceof SQLSubqueryTableSource) {
                    SQLExpr other;
                    SQLSelect select = ((SQLSubqueryTableSource)resolvedTableSource).getSelect();
                    SQLSelectQueryBlock queryBlock = select.getFirstQueryBlock();
                    if (queryBlock == null || queryBlock.getGroupBy() != null && original.getParent() instanceof SQLBinaryOpExpr && !SQLExprUtils.isLiteralExpr(other = ((SQLBinaryOpExpr)original.getParent()).other(original))) break block16;
                    SQLSelectItem selectItem = queryBlock.findSelectItem(propertyExpr.nameHashCode64());
                    if (selectItem != null) {
                        expr = selectItem.getExpr();
                        continue;
                    }
                    if (queryBlock.selectItemHasAllColumn()) {
                        SQLTableSource allColumnTableSource = null;
                        SQLTableSource from = queryBlock.getFrom();
                        if (from instanceof SQLJoinTableSource) {
                            SQLExpr owner;
                            SQLSelectItem allColumnSelectItem = queryBlock.findAllColumnSelectItem();
                            if (allColumnSelectItem != null && allColumnSelectItem.getExpr() instanceof SQLPropertyExpr && (owner = ((SQLPropertyExpr)allColumnSelectItem.getExpr()).getOwner()) instanceof SQLName) {
                                allColumnTableSource = from.findTableSource(((SQLName)owner).nameHashCode64());
                            }
                        } else {
                            allColumnTableSource = from;
                        }
                        if (allColumnTableSource != null) {
                            propertyExpr = propertyExpr.clone();
                            propertyExpr.setResolvedTableSource(allColumnTableSource);
                            if (allColumnTableSource instanceof SQLExprTableSource) {
                                propertyExpr.setOwner(((SQLExprTableSource)allColumnTableSource).getExpr().clone());
                            }
                            expr = propertyExpr;
                            continue;
                        }
                    }
                    break block16;
                }
                if (!(resolvedTableSource instanceof SQLExprTableSource) || (exprTableSource = (SQLExprTableSource)resolvedTableSource).getSchemaObject() != null) break block16;
                SQLTableSource redirectTableSource = null;
                tableSourceExpr = exprTableSource.getExpr();
                if (tableSourceExpr instanceof SQLIdentifierExpr) {
                    redirectTableSource = ((SQLIdentifierExpr)tableSourceExpr).getResolvedTableSource();
                } else if (tableSourceExpr instanceof SQLPropertyExpr) {
                    redirectTableSource = ((SQLPropertyExpr)tableSourceExpr).getResolvedTableSource();
                }
                if (redirectTableSource == resolvedTableSource) {
                    redirectTableSource = null;
                }
                if (redirectTableSource == null) break;
                propertyExpr = propertyExpr.clone();
                if (redirectTableSource instanceof SQLExprTableSource) {
                    propertyExpr.setOwner(((SQLExprTableSource)redirectTableSource).getExpr().clone());
                }
                propertyExpr.setResolvedTableSource(redirectTableSource);
                expr = propertyExpr;
            }
            propertyExpr = propertyExpr.clone();
            propertyExpr.setOwner(tableSourceExpr);
            expr = propertyExpr;
        }
        return expr;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.setMode(x, TableStat.Mode.Delete);
        for (SQLExprTableSource tableSource : x.getTableSources()) {
            SQLName name = (SQLName)tableSource.getExpr();
            TableStat stat = this.getTableStat(name);
            stat.incrementDeleteCount();
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropViewStatement x) {
        this.setMode(x, TableStat.Mode.Drop);
        return true;
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        this.setMode(x, TableStat.Mode.Insert);
        for (SQLExprTableSource tableSource : x.getTableSources()) {
            SQLName name = (SQLName)tableSource.getExpr();
            TableStat stat = this.getTableStat(name);
            stat.incrementDropCount();
        }
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Insert);
        if (x.getTableName() instanceof SQLName) {
            String ident = x.getTableName().toString();
            TableStat stat = this.getTableStat(x.getTableName());
            stat.incrementInsertCount();
        }
        this.accept(x.getColumns());
        this.accept(x.getQuery());
        return false;
    }

    protected static void putAliasMap(Map<String, String> aliasMap, String name, String value) {
        if (aliasMap == null || name == null) {
            return;
        }
        aliasMap.put(name.toLowerCase(), value);
    }

    protected void accept(SQLObject x) {
        if (x != null) {
            x.accept(this);
        }
    }

    protected void accept(List<? extends SQLObject> nodes) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            this.accept(nodes.get(i));
        }
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        List<SQLSelectOrderByItem> sortBy;
        List<SQLExpr> distributeBy;
        SQLExpr first;
        SQLOrderBy orderBy;
        SQLSelectGroupByClause groupBy;
        SQLExpr connectBy;
        SQLExpr startWith;
        SQLExprTableSource into;
        if (x.getFrom() == null) {
            for (SQLSelectItem selectItem : x.getSelectList()) {
                this.statExpr(selectItem.getExpr());
            }
            return false;
        }
        this.setMode(x, TableStat.Mode.Select);
        SQLTableSource from = x.getFrom();
        if (from != null) {
            from.accept(this);
        }
        if ((into = x.getInto()) != null && into.getExpr() instanceof SQLName) {
            TableStat stat;
            boolean isParam;
            SQLName intoExpr = (SQLName)into.getExpr();
            boolean bl = isParam = intoExpr instanceof SQLIdentifierExpr && SchemaStatVisitor.isParam((SQLIdentifierExpr)intoExpr);
            if (!isParam && (stat = this.getTableStat(intoExpr)) != null) {
                stat.incrementInsertCount();
            }
            into.accept(this);
        }
        for (SQLSelectItem selectItem : x.getSelectList()) {
            this.statExpr(selectItem.getExpr());
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            this.statExpr(where);
        }
        if ((startWith = x.getStartWith()) != null) {
            this.statExpr(startWith);
        }
        if ((connectBy = x.getConnectBy()) != null) {
            this.statExpr(connectBy);
        }
        if ((groupBy = x.getGroupBy()) != null) {
            for (SQLExpr expr : groupBy.getItems()) {
                this.statExpr(expr);
            }
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.visit(orderBy);
        }
        if ((first = x.getFirst()) != null) {
            this.statExpr(first);
        }
        if ((distributeBy = x.getDistributeBy()) != null) {
            for (SQLExpr expr : distributeBy) {
                this.statExpr(expr);
            }
        }
        if ((sortBy = x.getSortBy()) != null) {
            for (SQLSelectOrderByItem orderByItem : sortBy) {
                this.visit(orderBy);
            }
        }
        for (SQLExpr expr : x.getForUpdateOf()) {
            this.statExpr(expr);
        }
        return false;
    }

    private static boolean isParam(SQLIdentifierExpr x) {
        return x.getResolvedParameter() != null || x.getResolvedDeclareItem() != null;
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        this.setModeOrigin(x);
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        SQLTableSource left = x.getLeft();
        SQLTableSource right = x.getRight();
        left.accept(this);
        right.accept(this);
        SQLExpr condition = x.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if (x.getUsing().size() > 0 && left instanceof SQLExprTableSource && right instanceof SQLExprTableSource) {
            SQLExpr leftExpr = ((SQLExprTableSource)left).getExpr();
            SQLExpr rightExpr = ((SQLExprTableSource)right).getExpr();
            for (SQLExpr expr : x.getUsing()) {
                if (!(expr instanceof SQLIdentifierExpr)) continue;
                String name = ((SQLIdentifierExpr)expr).getName();
                SQLPropertyExpr leftPropExpr = new SQLPropertyExpr(leftExpr, name);
                SQLPropertyExpr rightPropExpr = new SQLPropertyExpr(rightExpr, name);
                leftPropExpr.setResolvedTableSource(left);
                rightPropExpr.setResolvedTableSource(right);
                SQLBinaryOpExpr usingCondition = new SQLBinaryOpExpr((SQLExpr)leftPropExpr, SQLBinaryOperator.Equality, rightPropExpr);
                usingCondition.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        TableStat.Column column = null;
        String ident = x.getName();
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLTableSource resolvedTableSource;
            SQLExprImpl table;
            SQLExpr expr = ((SQLExprTableSource)tableSource).getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                table = (SQLIdentifierExpr)expr;
                resolvedTableSource = ((SQLIdentifierExpr)table).getResolvedTableSource();
                if (resolvedTableSource instanceof SQLExprTableSource) {
                    expr = ((SQLExprTableSource)resolvedTableSource).getExpr();
                }
            } else if (expr instanceof SQLPropertyExpr && (resolvedTableSource = ((SQLPropertyExpr)(table = (SQLPropertyExpr)expr)).getResolvedTableSource()) instanceof SQLExprTableSource) {
                expr = ((SQLExprTableSource)resolvedTableSource).getExpr();
            }
            if (expr instanceof SQLIdentifierExpr) {
                table = (SQLIdentifierExpr)expr;
                resolvedTableSource = ((SQLIdentifierExpr)table).getResolvedTableSource();
                if (resolvedTableSource instanceof SQLWithSubqueryClause.Entry) {
                    return false;
                }
                column = this.addColumn(((SQLIdentifierExpr)table).getName(), ident);
                if (column != null && this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLPropertyExpr) {
                table = (SQLPropertyExpr)expr;
                String tableName = ((SQLPropertyExpr)table).toString();
                column = this.addColumn(tableName, ident);
                if (column != null && this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLMethodInvokeExpr && "table".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)expr).getMethodName()) && methodInvokeExpr.getParameters().size() == 1 && methodInvokeExpr.getParameters().get(0) instanceof SQLName) {
                SQLName table2 = (SQLName)methodInvokeExpr.getParameters().get(0);
                String tableName = null;
                if (table2 instanceof SQLPropertyExpr) {
                    SQLExpr resolveExpr;
                    SQLPropertyExpr propertyExpr = (SQLPropertyExpr)table2;
                    SQLIdentifierExpr owner = (SQLIdentifierExpr)propertyExpr.getOwner();
                    if (propertyExpr.getResolvedTableSource() != null && propertyExpr.getResolvedTableSource() instanceof SQLExprTableSource && (resolveExpr = ((SQLExprTableSource)propertyExpr.getResolvedTableSource()).getExpr()) instanceof SQLName) {
                        tableName = resolveExpr.toString() + "." + propertyExpr.getName();
                    }
                }
                if (tableName == null) {
                    tableName = table2.toString();
                }
                column = this.addColumn(tableName, ident);
            }
        } else {
            if (tableSource instanceof SQLWithSubqueryClause.Entry || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLUnionQueryTableSource || tableSource instanceof SQLLateralViewTableSource || tableSource instanceof SQLValuesTableSource) {
                return false;
            }
            if (x.getResolvedProcudure() != null) {
                return false;
            }
            if (x.getResolvedOwnerObject() instanceof SQLParameter) {
                return false;
            }
            boolean skip = false;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                    if (!(from instanceof OdpsValuesTableSource)) continue;
                    skip = true;
                    break;
                }
                if (parent instanceof SQLSelectQuery) break;
            }
            if (!skip) {
                column = this.handleUnkownColumn(ident);
            }
        }
        if (column != null) {
            SQLObject parent = x.getParent();
            if (parent instanceof SQLSelectOrderByItem) {
                parent = parent.getParent();
            }
            if (parent instanceof SQLPrimaryKey) {
                column.setPrimaryKey(true);
            } else if (parent instanceof SQLUnique) {
                column.setUnique(true);
            }
            this.setColumn(x, column);
        }
        return false;
    }

    protected boolean isPseudoColumn(long hash) {
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        SQLSelectOrderByItem selectOrderByItem;
        if (SchemaStatVisitor.isParam(x)) {
            return false;
        }
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (x.getParent() instanceof SQLSelectOrderByItem && (selectOrderByItem = (SQLSelectOrderByItem)x.getParent()).getResolvedSelectItem() != null) {
            return false;
        }
        if (tableSource == null && (x.getResolvedParameter() != null || x.getResolvedDeclareItem() != null)) {
            return false;
        }
        long hash = x.nameHashCode64();
        if (this.isPseudoColumn(hash)) {
            return false;
        }
        if ((hash == FnvHash.Constants.LEVEL || hash == FnvHash.Constants.CONNECT_BY_ISCYCLE || hash == FnvHash.Constants.ROWNUM) && x.getResolvedColumn() == null && tableSource == null) {
            return false;
        }
        TableStat.Column column = null;
        String ident = x.getName();
        if (tableSource instanceof SQLExprTableSource) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLExpr expr = ((SQLExprTableSource)tableSource).getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr table = (SQLIdentifierExpr)expr;
                column = this.addColumn(table, ident);
                if (column != null && this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLPropertyExpr || expr instanceof OracleDbLinkExpr) {
                String tableName = expr.toString();
                column = this.addColumn(tableName, ident);
                if (column != null && this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLMethodInvokeExpr && "table".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)expr).getMethodName()) && methodInvokeExpr.getParameters().size() == 1 && methodInvokeExpr.getParameters().get(0) instanceof SQLName) {
                SQLName table = (SQLName)methodInvokeExpr.getParameters().get(0);
                String tableName = null;
                if (table instanceof SQLPropertyExpr) {
                    SQLExpr resolveExpr;
                    SQLPropertyExpr propertyExpr = (SQLPropertyExpr)table;
                    SQLIdentifierExpr owner = (SQLIdentifierExpr)propertyExpr.getOwner();
                    if (propertyExpr.getResolvedTableSource() != null && propertyExpr.getResolvedTableSource() instanceof SQLExprTableSource && (resolveExpr = ((SQLExprTableSource)propertyExpr.getResolvedTableSource()).getExpr()) instanceof SQLName) {
                        tableName = resolveExpr.toString() + "." + propertyExpr.getName();
                    }
                }
                if (tableName == null) {
                    tableName = table.toString();
                }
                column = this.addColumn(tableName, ident);
            }
        } else {
            if (tableSource instanceof SQLWithSubqueryClause.Entry || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLValuesTableSource || tableSource instanceof SQLLateralViewTableSource) {
                return false;
            }
            boolean skip = false;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                    if (!(from instanceof OdpsValuesTableSource)) continue;
                    skip = true;
                    break;
                }
                if (parent instanceof SQLSelectQuery) break;
            }
            if (!skip) {
                column = this.handleUnkownColumn(ident);
            }
        }
        if (column != null) {
            SQLObject parent = x.getParent();
            if (parent instanceof SQLSelectOrderByItem) {
                parent = parent.getParent();
            }
            if (parent instanceof SQLPrimaryKey) {
                column.setPrimaryKey(true);
            } else if (parent instanceof SQLUnique) {
                column.setUnique(true);
            }
            this.setColumn(x, column);
        }
        return false;
    }

    private boolean isParentSelectItem(SQLObject parent) {
        while (parent != null) {
            if (parent instanceof SQLSelectItem) {
                return true;
            }
            if (parent instanceof SQLSelectQueryBlock) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean isParentGroupBy(SQLObject parent) {
        while (parent != null) {
            if (parent instanceof SQLSelectItem) {
                return false;
            }
            if (parent instanceof SQLSelectGroupByClause) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private void setColumn(SQLExpr x, TableStat.Column column) {
        SQLObject parent;
        SQLObject current = x;
        while ((parent = current.getParent()) != null) {
            if (parent instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock query = (SQLSelectQueryBlock)parent;
                if (query.getWhere() != current) break;
                column.setWhere(true);
                break;
            }
            if (parent instanceof SQLSelectGroupByClause) {
                SQLSelectGroupByClause groupBy = (SQLSelectGroupByClause)parent;
                if (current == groupBy.getHaving()) {
                    column.setHaving(true);
                    break;
                }
                if (!groupBy.getItems().contains(current)) break;
                column.setGroupBy(true);
                break;
            }
            if (this.isParentSelectItem(parent)) {
                column.setSelec(true);
                break;
            }
            if (parent instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)parent;
                if (join.getCondition() != current) break;
                column.setJoin(true);
                break;
            }
            current = parent;
        }
    }

    protected TableStat.Column handleUnkownColumn(String columnName) {
        return this.addColumn("UNKNOWN", columnName);
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource == null) {
            return false;
        }
        this.statAllColumn(x, tableSource);
        return false;
    }

    private void statAllColumn(SQLAllColumnExpr x, SQLTableSource tableSource) {
        if (tableSource instanceof SQLExprTableSource) {
            this.statAllColumn(x, (SQLExprTableSource)tableSource);
            return;
        }
        if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            this.statAllColumn(x, join.getLeft());
            this.statAllColumn(x, join.getRight());
        }
    }

    private void statAllColumn(SQLAllColumnExpr x, SQLExprTableSource tableSource) {
        SQLStatement stmt;
        SQLExprTableSource exprTableSource = tableSource;
        SQLName expr = exprTableSource.getName();
        SQLCreateTableStatement createStmt = null;
        SchemaObject tableObject = exprTableSource.getSchemaObject();
        if (tableObject != null && (stmt = tableObject.getStatement()) instanceof SQLCreateTableStatement) {
            createStmt = (SQLCreateTableStatement)stmt;
        }
        if (createStmt != null && createStmt.getTableElementList().size() > 0) {
            SQLName tableName = createStmt.getName();
            for (SQLTableElement e : createStmt.getTableElementList()) {
                if (!(e instanceof SQLColumnDefinition)) continue;
                SQLColumnDefinition columnDefinition = (SQLColumnDefinition)e;
                SQLName columnName = columnDefinition.getName();
                TableStat.Column column = this.addColumn(tableName.toString(), columnName.toString());
                if (!this.isParentSelectItem(x.getParent())) continue;
                column.setSelec(true);
            }
        } else if (expr != null) {
            TableStat.Column column = this.addColumn(expr.toString(), "*");
            if (this.isParentSelectItem(x.getParent())) {
                column.setSelec(true);
            }
        }
    }

    public Map<TableStat.Name, TableStat> getTables() {
        return this.tableStats;
    }

    public boolean containsTable(String tableName) {
        return this.tableStats.containsKey(new TableStat.Name(tableName));
    }

    public boolean containsColumn(String tableName, String columnName) {
        long hashCode;
        int p = tableName.indexOf(46);
        if (p != -1) {
            SQLExpr owner = SQLUtils.toSQLExpr(tableName, this.dbType);
            hashCode = new SQLPropertyExpr(owner, columnName).hashCode64();
        } else {
            hashCode = FnvHash.hashCode64(tableName, columnName);
        }
        return this.columns.containsKey(hashCode);
    }

    public Collection<TableStat.Column> getColumns() {
        return this.columns.values();
    }

    public TableStat.Column getColumn(String tableName, String columnName) {
        TableStat.Column column = new TableStat.Column(tableName, columnName);
        return this.columns.get(column.hashCode64());
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.visit(x.getSelect());
        return false;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        String alias = x.getAlias();
        SQLWithSubqueryClause with = (SQLWithSubqueryClause)x.getParent();
        if (Boolean.TRUE == with.getRecursive()) {
            SQLSelect select = x.getSubQuery();
            if (select != null) {
                select.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
        } else {
            SQLSelect select = x.getSubQuery();
            if (select != null) {
                select.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        x.getSelect().accept(this);
        return false;
    }

    protected boolean isSimpleExprTableSource(SQLExprTableSource x) {
        return x.getExpr() instanceof SQLName;
    }

    public TableStat getTableStat(SQLExprTableSource tableSource) {
        return this.getTableStatWithUnwrap(tableSource.getExpr());
    }

    private TableStat getTableStatWithUnwrap(SQLExpr expr) {
        SQLExpr tableSourceExpr;
        SQLExpr identExpr = null;
        if ((expr = this.unwrapExpr(expr)) instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            if (identifierExpr.nameHashCode64() == FnvHash.Constants.DUAL) {
                return null;
            }
            if (this.isSubQueryOrParamOrVariant(identifierExpr)) {
                return null;
            }
        }
        SQLTableSource tableSource = null;
        if (expr instanceof SQLIdentifierExpr) {
            tableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource();
        } else if (expr instanceof SQLPropertyExpr) {
            tableSource = ((SQLPropertyExpr)expr).getResolvedTableSource();
        }
        if (tableSource instanceof SQLExprTableSource && (tableSourceExpr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLName) {
            identExpr = tableSourceExpr;
        }
        if (identExpr == null) {
            identExpr = expr;
        }
        if (identExpr instanceof SQLName) {
            return this.getTableStat((SQLName)identExpr);
        }
        return this.getTableStat(identExpr.toString());
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        if (this.isSimpleExprTableSource(x)) {
            SQLExpr expr = x.getExpr();
            TableStat stat = this.getTableStatWithUnwrap(expr);
            if (stat == null) {
                return false;
            }
            TableStat.Mode mode = this.getMode();
            if (mode != null) {
                switch (mode) {
                    case Delete: {
                        stat.incrementDeleteCount();
                        break;
                    }
                    case Insert: {
                        stat.incrementInsertCount();
                        break;
                    }
                    case Update: {
                        stat.incrementUpdateCount();
                        break;
                    }
                    case Select: {
                        stat.incrementSelectCount();
                        break;
                    }
                    case Merge: {
                        stat.incrementMergeCount();
                        break;
                    }
                    case Drop: {
                        stat.incrementDropCount();
                        break;
                    }
                }
            }
        } else {
            this.accept(x.getExpr());
        }
        return false;
    }

    protected boolean isSubQueryOrParamOrVariant(SQLIdentifierExpr identifierExpr) {
        SQLObject resolvedColumnObject = identifierExpr.getResolvedColumnObject();
        if (resolvedColumnObject instanceof SQLWithSubqueryClause.Entry || resolvedColumnObject instanceof SQLParameter || resolvedColumnObject instanceof SQLDeclareItem) {
            return true;
        }
        SQLObject resolvedOwnerObject = identifierExpr.getResolvedOwnerObject();
        return resolvedOwnerObject instanceof SQLSubqueryTableSource || resolvedOwnerObject instanceof SQLWithSubqueryClause.Entry;
    }

    protected boolean isSubQueryOrParamOrVariant(SQLPropertyExpr x) {
        SQLObject resolvedOwnerObject = x.getResolvedOwnerObject();
        if (resolvedOwnerObject instanceof SQLSubqueryTableSource || resolvedOwnerObject instanceof SQLWithSubqueryClause.Entry) {
            return true;
        }
        SQLExpr owner = x.getOwner();
        if (owner instanceof SQLIdentifierExpr && this.isSubQueryOrParamOrVariant((SQLIdentifierExpr)owner)) {
            return true;
        }
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
            if (exprTableSource.getSchemaObject() != null) {
                return false;
            }
            SQLExpr expr = exprTableSource.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                return this.isSubQueryOrParamOrVariant((SQLIdentifierExpr)expr);
            }
            if (expr instanceof SQLPropertyExpr) {
                return this.isSubQueryOrParamOrVariant((SQLPropertyExpr)expr);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        this.statExpr(x.getExpr());
        return false;
    }

    @Override
    public void endVisit(SQLSelect x) {
    }

    @Override
    public boolean visit(SQLSelect x) {
        SQLOrderBy orderBy;
        SQLSelectQuery query;
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            with.accept(this);
        }
        if ((query = x.getQuery()) != null) {
            query.accept(this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.accept(x.getOrderBy());
        }
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.aggregateFunctions.add(x);
        this.accept(x.getArguments());
        this.accept(x.getWithinGroup());
        this.accept(x.getOver());
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        this.functions.add(x);
        this.accept(x.getParameters());
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Update);
        SQLTableSource tableSource = x.getTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            SQLName identName = ((SQLExprTableSource)tableSource).getName();
            TableStat stat = this.getTableStat(identName);
            stat.incrementUpdateCount();
        } else {
            tableSource.accept(this);
        }
        this.accept(x.getFrom());
        this.accept(x.getItems());
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        SQLSelectQuery selectQuery;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Delete);
        if (x.getTableSource() instanceof SQLSubqueryTableSource && (selectQuery = ((SQLSubqueryTableSource)x.getTableSource()).getSelect().getQuery()) instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock subQueryBlock = (SQLSelectQueryBlock)selectQuery;
            subQueryBlock.getWhere().accept(this);
        }
        TableStat stat = this.getTableStat(x.getTableName());
        stat.incrementDeleteCount();
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        if (x.isNot()) {
            this.handleCondition(x.getExpr(), "NOT IN", x.getTargetList());
        } else {
            this.handleCondition(x.getExpr(), "IN", x.getTargetList());
        }
        return true;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        if (x.isNot()) {
            this.handleCondition(x.getExpr(), "NOT IN", new SQLExpr[0]);
        } else {
            this.handleCondition(x.getExpr(), "IN", new SQLExpr[0]);
        }
        return true;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        for (SQLTableElement e : x.getTableElementList()) {
            e.setParent(x);
        }
        TableStat stat = this.getTableStat(x.getName());
        stat.incrementCreateCount();
        this.accept(x.getTableElementList());
        if (x.getInherits() != null) {
            x.getInherits().accept(this);
        }
        if (x.getSelect() != null) {
            x.getSelect().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        String tableName = null;
        SQLObject parent = x.getParent();
        if (parent instanceof SQLCreateTableStatement) {
            tableName = ((SQLCreateTableStatement)parent).getName().toString();
        }
        if (tableName == null) {
            return true;
        }
        String columnName = x.getName().toString();
        TableStat.Column column = this.addColumn(tableName, columnName);
        if (x.getDataType() != null) {
            column.setDataType(x.getDataType().getName());
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            if (item instanceof SQLPrimaryKey) {
                column.setPrimaryKey(true);
                continue;
            }
            if (!(item instanceof SQLUnique)) continue;
            column.setUnique(true);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        return false;
    }

    @Override
    public void endVisit(SQLCommentStatement x) {
    }

    @Override
    public boolean visit(SQLCommentStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCurrentOfCursorExpr x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        String table = stmt.getName().toString();
        for (SQLColumnDefinition column : x.getColumns()) {
            String columnName = column.getName().toString();
            this.addColumn(table, columnName);
        }
        return false;
    }

    @Override
    public void endVisit(SQLAlterTableAddColumn x) {
    }

    @Override
    public boolean visit(SQLRollbackStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateViewStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterViewStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropForeignKey x) {
        return false;
    }

    @Override
    public boolean visit(SQLUseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableConstraint x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableConstraint x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        TableStat stat = this.getTableStat(x.getName());
        stat.incrementAlterCount();
        for (SQLAlterTableItem item : x.getItems()) {
            item.setParent(x);
            item.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropConstraint x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropIndexStatement x) {
        this.setMode(x, TableStat.Mode.DropIndex);
        SQLExprTableSource table = x.getTableName();
        if (table != null) {
            SQLName name = (SQLName)table.getExpr();
            TableStat stat = this.getTableStat(name);
            stat.incrementDropIndexCount();
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        this.setMode(x, TableStat.Mode.CreateIndex);
        SQLName name = (SQLName)((SQLExprTableSource)x.getTable()).getExpr();
        String table = name.toString();
        TableStat stat = this.getTableStat(name);
        stat.incrementCreateIndexCount();
        for (SQLSelectOrderByItem item : x.getItems()) {
            SQLExpr expr = item.getExpr();
            if (!(expr instanceof SQLIdentifierExpr)) continue;
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
            String columnName = identExpr.getName();
            this.addColumn(table, columnName);
        }
        return false;
    }

    @Override
    public boolean visit(SQLForeignKeyImpl x) {
        for (SQLName column : x.getReferencingColumns()) {
            column.accept(this);
        }
        String table = x.getReferencedTableName().getSimpleName();
        TableStat stat = this.getTableStat(x.getReferencedTableName());
        stat.incrementReferencedCount();
        for (SQLName column : x.getReferencedColumns()) {
            String columnName = column.getSimpleName();
            this.addColumn(table, columnName);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropSequenceStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropTriggerStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropUserStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLGrantStatement x) {
        if (x.getOn() != null && (x.getObjectType() == null || x.getObjectType() == SQLObjectType.TABLE)) {
            x.getOn().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLRevokeStatement x) {
        if (x.getOn() != null) {
            x.getOn().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropDatabaseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddIndex x) {
        for (SQLSelectOrderByItem item : x.getItems()) {
            item.accept(this);
        }
        SQLName table = ((SQLAlterTableStatement)x.getParent()).getName();
        TableStat tableStat = this.getTableStat(table);
        tableStat.incrementCreateIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLCheck x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTriggerStatement x) {
        SQLExprTableSource on = x.getOn();
        on.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropFunctionStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropTableSpaceStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropProcedureStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRename x) {
        return false;
    }

    @Override
    public boolean visit(SQLArrayExpr x) {
        this.accept(x.getValues());
        SQLExpr exp = x.getExpr();
        if (exp instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)exp).getName().equals("ARRAY")) {
            return false;
        }
        exp.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLOpenStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLFetchStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCloseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateProcedureStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.accept(x.getBlock());
        return false;
    }

    @Override
    public boolean visit(SQLCreateFunctionStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.accept(x.getBlock());
        return false;
    }

    @Override
    public boolean visit(SQLBlockStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        for (SQLParameter param : x.getParameters()) {
            param.setParent(x);
            param.accept(this);
        }
        for (SQLStatement stmt : x.getStatementList()) {
            stmt.accept(this);
        }
        SQLStatement exception = x.getException();
        if (exception != null) {
            exception.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLShowTablesStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDeclareItem x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByHash x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByRange x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByList x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLSubPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLSubPartitionByHash x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionValue x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterDatabaseStatement x) {
        return true;
    }

    @Override
    public boolean visit(SQLAlterTableConvertCharSet x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableReOrganizePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableCoalescePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableTruncatePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDiscardPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableImportPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAnalyzePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableCheckPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableOptimizePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRebuildPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRepairPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLSequenceExpr x) {
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x.getUsing(), TableStat.Mode.Select);
        x.getUsing().accept(this);
        this.setMode(x, TableStat.Mode.Merge);
        SQLTableSource into = x.getInto();
        if (into instanceof SQLExprTableSource) {
            String ident = ((SQLExprTableSource)into).getExpr().toString();
            TableStat stat = this.getTableStat(ident);
            stat.incrementMergeCount();
        } else {
            into.accept(this);
        }
        x.getOn().accept(this);
        if (x.getUpdateClause() != null) {
            x.getUpdateClause().accept(this);
        }
        if (x.getInsertClause() != null) {
            x.getInsertClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        return false;
    }

    public List<SQLMethodInvokeExpr> getFunctions() {
        return this.functions;
    }

    @Override
    public boolean visit(SQLCreateSequenceStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddConstraint x) {
        SQLConstraint constraint = x.getConstraint();
        if (constraint instanceof SQLUniqueConstraint) {
            SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
            TableStat tableStat = this.getTableStat(stmt.getName());
            tableStat.incrementCreateIndexCount();
        }
        return true;
    }

    @Override
    public boolean visit(SQLAlterTableDropIndex x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        TableStat tableStat = this.getTableStat(stmt.getName());
        tableStat.incrementDropIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPrimaryKey x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        TableStat tableStat = this.getTableStat(stmt.getName());
        tableStat.incrementDropIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropKey x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        TableStat tableStat = this.getTableStat(stmt.getName());
        tableStat.incrementDropIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLDescribeStatement x) {
        String tableName = x.getObject().toString();
        TableStat tableStat = this.getTableStat(x.getObject());
        tableStat.incrementDropIndexCount();
        SQLName column = x.getColumn();
        if (column != null) {
            String columnName = column.toString();
            this.addColumn(tableName, columnName);
        }
        return false;
    }

    @Override
    public boolean visit(SQLExplainStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if (x.getStatement() != null) {
            this.accept(x.getStatement());
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateMaterializedViewStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        return true;
    }

    @Override
    public boolean visit(SQLReplaceStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Replace);
        SQLName tableName = x.getTableName();
        TableStat stat = this.getTableStat(tableName);
        if (stat != null) {
            stat.incrementInsertCount();
        }
        this.accept(x.getColumns());
        this.accept(x.getValuesList());
        this.accept(x.getQuery());
        return false;
    }

    protected final void statExpr(SQLExpr x) {
        Class<?> clazz = x.getClass();
        if (clazz == SQLIdentifierExpr.class) {
            this.visit((SQLIdentifierExpr)x);
        } else if (clazz == SQLPropertyExpr.class) {
            this.visit((SQLPropertyExpr)x);
        } else if (clazz == SQLBinaryOpExpr.class) {
            this.visit((SQLBinaryOpExpr)x);
        } else if (!(x instanceof SQLLiteralExpr)) {
            x.accept(this);
        }
    }

    @Override
    public boolean visit(SQLAlterFunctionStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropSynonymStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTypeStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterProcedureStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLExprStatement x) {
        SQLExpr expr = x.getExpr();
        return !(expr instanceof SQLName);
    }

    @Override
    public boolean visit(SQLDropTypeStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLExternalRecordFormat x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableExchangePartition x) {
        SQLExprTableSource table = x.getTable();
        if (table != null) {
            table.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDumpStatement x) {
        SQLSelect select;
        SQLExprTableSource into;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if ((into = x.getInto()) != null) {
            into.accept(this);
        }
        if ((select = x.getSelect()) != null) {
            select.accept(this);
        }
        return false;
    }

    protected class OracleOrderByStatVisitor
    extends PGASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public OracleOrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SQLExpr unwrapped = SchemaStatVisitor.this.unwrapExpr(x);
            if (unwrapped instanceof SQLPropertyExpr) {
                SchemaStatVisitor.this.visitOrderBy((SQLPropertyExpr)unwrapped);
            } else if (unwrapped instanceof SQLIdentifierExpr) {
                SchemaStatVisitor.this.visitOrderBy((SQLIdentifierExpr)unwrapped);
            }
            return false;
        }
    }

    protected class PGOrderByStatVisitor
    extends PGASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public PGOrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }
    }

    protected class MySqlOrderByStatVisitor
    extends MySqlASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public MySqlOrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }
    }

    protected class OrderByStatVisitor
    extends SQLASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public OrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }
    }
}

