/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidConnectionHolder;
import com.alibaba.druid.pool.DruidPooledCallableStatement;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.PoolableWrapper;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.proxy.jdbc.TransactionInfo;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class DruidPooledConnection
extends PoolableWrapper
implements PooledConnection,
Connection {
    private static final Log LOG = LogFactory.getLog(DruidPooledConnection.class);
    public static final int MAX_RECORD_SQL_COUNT = 10;
    protected Connection conn;
    protected volatile DruidConnectionHolder holder;
    protected TransactionInfo transactionInfo;
    private final boolean dupCloseLogEnable;
    private volatile boolean traceEnable = false;
    private boolean disable = false;
    private boolean closed = false;
    private final Thread ownerThread;
    private long connectedTimeMillis;
    private long connectedTimeNano;
    private volatile boolean running = false;
    private volatile boolean abandoned = false;
    private StackTraceElement[] connectStackTrace;
    private Throwable disableError = null;
    public ReentrantLock lock = new ReentrantLock();

    public DruidPooledConnection(DruidConnectionHolder holder) {
        super(holder.getConnection());
        this.conn = holder.getConnection();
        this.holder = holder;
        this.dupCloseLogEnable = holder.getDataSource().isDupCloseLogEnable();
        this.ownerThread = Thread.currentThread();
        this.connectedTimeMillis = System.currentTimeMillis();
    }

    public long getConnectedTimeMillis() {
        return this.connectedTimeMillis;
    }

    public Thread getOwnerThread() {
        return this.ownerThread;
    }

    public StackTraceElement[] getConnectStackTrace() {
        return this.connectStackTrace;
    }

    public void setConnectStackTrace(StackTraceElement[] connectStackTrace) {
        this.connectStackTrace = connectStackTrace;
    }

    public long getConnectedTimeNano() {
        return this.connectedTimeNano;
    }

    public void setConnectedTimeNano() {
        if (this.connectedTimeNano <= 0L) {
            this.setConnectedTimeNano(System.nanoTime());
        }
    }

    public void setConnectedTimeNano(long connectedTimeNano) {
        this.connectedTimeNano = connectedTimeNano;
    }

    public boolean isTraceEnable() {
        return this.traceEnable;
    }

    public void setTraceEnable(boolean traceEnable) {
        this.traceEnable = traceEnable;
    }

    public SQLException handleException(Throwable t) throws SQLException {
        DruidConnectionHolder holder = this.holder;
        if (holder != null) {
            DruidAbstractDataSource dataSource = holder.getDataSource();
            dataSource.handleConnectionException(this, t);
        }
        if (t instanceof SQLException) {
            throw (SQLException)t;
        }
        throw new SQLException("Error", t);
    }

    public boolean isOracle() {
        return this.holder.getDataSource().isOracle();
    }

    public void closePoolableStatement(DruidPooledPreparedStatement stmt) throws SQLException {
        PreparedStatement rawStatement = stmt.getRawPreparedStatement();
        if (this.holder == null) {
            return;
        }
        if (stmt.isPooled()) {
            try {
                rawStatement.clearParameters();
            }
            catch (SQLException ex) {
                this.handleException(ex);
                if (rawStatement.getConnection().isClosed()) {
                    return;
                }
                LOG.error("clear parameter error", ex);
            }
        }
        PreparedStatementHolder stmtHolder = stmt.getPreparedStatementHolder();
        stmtHolder.decrementInUseCount();
        if (stmt.isPooled() && this.holder.isPoolPreparedStatements() && stmt.exceptionCount == 0) {
            this.holder.getStatementPool().put(stmtHolder);
            stmt.clearResultSet();
            this.holder.removeTrace(stmt);
            stmtHolder.setFetchRowPeak(stmt.getFetchRowPeak());
            stmt.setClosed(true);
        } else if (stmt.isPooled() && this.holder.isPoolPreparedStatements()) {
            stmt.clearResultSet();
            this.holder.removeTrace(stmt);
            this.holder.getStatementPool().remove(stmtHolder);
        } else {
            try {
                stmt.closeInternal();
            }
            catch (SQLException ex) {
                this.handleException(ex);
                throw ex;
            }
            finally {
                this.holder.getDataSource().incrementClosedPreparedStatementCount();
            }
        }
    }

    public DruidConnectionHolder getConnectionHolder() {
        return this.holder;
    }

    @Override
    public Connection getConnection() {
        if (!this.holder.isUnderlyingAutoCommit()) {
            this.createTransactionInfo();
        }
        return this.conn;
    }

    public void disable() {
        this.disable(null);
    }

    public void disable(Throwable error) {
        if (this.holder != null) {
            this.holder.clearStatementCache();
        }
        this.traceEnable = false;
        this.holder = null;
        this.transactionInfo = null;
        this.disable = true;
        this.disableError = error;
    }

    public boolean isDisable() {
        return this.disable;
    }

    @Override
    public void close() throws SQLException {
        boolean isSameThread;
        if (this.disable) {
            return;
        }
        DruidConnectionHolder holder = this.holder;
        if (holder == null) {
            if (this.dupCloseLogEnable) {
                LOG.error("dup close");
            }
            return;
        }
        DruidAbstractDataSource dataSource = holder.getDataSource();
        boolean bl = isSameThread = this.getOwnerThread() == Thread.currentThread();
        if (!isSameThread) {
            dataSource.setAsyncCloseConnectionEnable(true);
        }
        if (dataSource.isAsyncCloseConnectionEnable()) {
            this.syncClose();
            return;
        }
        for (ConnectionEventListener listener : holder.getConnectionEventListeners()) {
            listener.connectionClosed(new ConnectionEvent(this));
        }
        List<Filter> filters = dataSource.getProxyFilters();
        if (filters.size() > 0) {
            FilterChainImpl filterChain = new FilterChainImpl(dataSource);
            filterChain.dataSource_recycle(this);
        } else {
            this.recycle();
        }
        this.disable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncClose() throws SQLException {
        this.lock.lock();
        try {
            if (this.disable) {
                return;
            }
            DruidConnectionHolder holder = this.holder;
            if (holder == null) {
                if (this.dupCloseLogEnable) {
                    LOG.error("dup close");
                }
                return;
            }
            for (ConnectionEventListener listener : holder.getConnectionEventListeners()) {
                listener.connectionClosed(new ConnectionEvent(this));
            }
            DruidAbstractDataSource dataSource = holder.getDataSource();
            List<Filter> filters = dataSource.getProxyFilters();
            if (filters.size() > 0) {
                FilterChainImpl filterChain = new FilterChainImpl(dataSource);
                filterChain.dataSource_recycle(this);
            } else {
                this.recycle();
            }
            this.disable = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void recycle() throws SQLException {
        if (this.disable) {
            return;
        }
        DruidConnectionHolder holder = this.holder;
        if (holder == null) {
            if (this.dupCloseLogEnable) {
                LOG.error("dup close");
            }
            return;
        }
        if (!this.abandoned) {
            DruidAbstractDataSource dataSource = holder.getDataSource();
            dataSource.recycle(this);
        }
        this.holder = null;
        this.conn = null;
        this.transactionInfo = null;
        this.closed = true;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M1);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    private void initStatement(PreparedStatementHolder stmtHolder) throws SQLException {
        stmtHolder.incrementInUseCount();
        this.holder.getDataSource().initStatement(this, stmtHolder.statement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M2, resultSetType, resultSetConcurrency);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M3, resultSetType, resultSetConcurrency, resultSetHoldability);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkState();
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M4, columnIndexes);
        PreparedStatementHolder stmtHolder = null;
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, columnIndexes));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkState();
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M5, columnNames);
        PreparedStatementHolder stmtHolder = null;
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, columnNames));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkState();
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M6, autoGeneratedKeys);
        PreparedStatementHolder stmtHolder = null;
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, autoGeneratedKeys));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.Precall_1);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareCall(sql));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledCallableStatement rtnVal = new DruidPooledCallableStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.Precall_2, resultSetType, resultSetConcurrency, resultSetHoldability);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledCallableStatement rtnVal = new DruidPooledCallableStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.Precall_3, resultSetType, resultSetConcurrency);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareCall(sql, resultSetType, resultSetConcurrency));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.initStatement(stmtHolder);
        DruidPooledCallableStatement rtnVal = new DruidPooledCallableStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkState();
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.getDataSource().initStatement(this, stmt);
        DruidPooledStatement poolableStatement = new DruidPooledStatement(this, stmt);
        this.holder.addTrace(poolableStatement);
        return poolableStatement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.getDataSource().initStatement(this, stmt);
        DruidPooledStatement poolableStatement = new DruidPooledStatement(this, stmt);
        this.holder.addTrace(poolableStatement);
        return poolableStatement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.getDataSource().initStatement(this, stmt);
        DruidPooledStatement poolableStatement = new DruidPooledStatement(this, stmt);
        this.holder.addTrace(poolableStatement);
        return poolableStatement;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkState();
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkState();
        boolean useLocalSessionState = this.holder.getDataSource().isUseLocalSessionState();
        if (useLocalSessionState && autoCommit == this.holder.isUnderlyingAutoCommit()) {
            return;
        }
        try {
            this.conn.setAutoCommit(autoCommit);
            this.holder.setUnderlyingAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
    }

    protected void transactionRecord(String sql) throws SQLException {
        List<String> sqlList;
        if (this.transactionInfo == null && !this.conn.getAutoCommit()) {
            DruidAbstractDataSource dataSource = this.holder.getDataSource();
            dataSource.incrementStartTransactionCount();
            this.transactionInfo = new TransactionInfo(dataSource.createTransactionId());
        }
        if (this.transactionInfo != null && (sqlList = this.transactionInfo.getSqlList()).size() < 10) {
            sqlList.add(sql);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkState();
        return this.conn.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.checkState();
        DruidAbstractDataSource dataSource = this.holder.getDataSource();
        dataSource.incrementCommitCount();
        try {
            this.conn.commit();
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        finally {
            this.handleEndTransaction(dataSource, null);
        }
    }

    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    protected void createTransactionInfo() {
        DruidAbstractDataSource dataSource = this.holder.getDataSource();
        dataSource.incrementStartTransactionCount();
        this.transactionInfo = new TransactionInfo(dataSource.createTransactionId());
    }

    @Override
    public void rollback() throws SQLException {
        if (this.transactionInfo == null) {
            return;
        }
        if (this.holder == null) {
            return;
        }
        DruidAbstractDataSource dataSource = this.holder.getDataSource();
        dataSource.incrementRollbackCount();
        try {
            this.conn.rollback();
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        finally {
            this.handleEndTransaction(dataSource, null);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkState();
        try {
            return this.conn.setSavepoint(name);
        }
        catch (SQLException ex) {
            this.handleException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.holder == null) {
            return;
        }
        DruidAbstractDataSource dataSource = this.holder.getDataSource();
        dataSource.incrementRollbackCount();
        try {
            this.conn.rollback(savepoint);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        finally {
            this.handleEndTransaction(dataSource, savepoint);
        }
    }

    private void handleEndTransaction(DruidAbstractDataSource dataSource, Savepoint savepoint) {
        if (this.transactionInfo != null && savepoint == null) {
            this.transactionInfo.setEndTimeMillis();
            long transactionMillis = this.transactionInfo.getEndTimeMillis() - this.transactionInfo.getStartTimeMillis();
            dataSource.getTransactionHistogram().record(transactionMillis);
            dataSource.logTransaction(this.transactionInfo);
            this.transactionInfo = null;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkState();
        try {
            this.conn.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkState();
        try {
            return this.conn.createClob();
        }
        catch (SQLException ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.holder == null) {
            return true;
        }
        return this.conn.isClosed();
    }

    public boolean isAbandonded() {
        return this.abandoned;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkState();
        if (!this.holder.isUnderlyingAutoCommit()) {
            this.createTransactionInfo();
        }
        return this.conn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkState();
        boolean useLocalSessionState = this.holder.getDataSource().isUseLocalSessionState();
        if (useLocalSessionState && readOnly == this.holder.isUnderlyingReadOnly()) {
            return;
        }
        try {
            this.conn.setReadOnly(readOnly);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.setUnderlyingReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkState();
        return this.conn.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkState();
        try {
            this.conn.setCatalog(catalog);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkState();
        return this.conn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkState();
        boolean useLocalSessionState = this.holder.getDataSource().isUseLocalSessionState();
        if (useLocalSessionState && level == this.holder.getUnderlyingTransactionIsolation()) {
            return;
        }
        try {
            this.conn.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.setUnderlyingTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkState();
        return this.holder.getUnderlyingTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.conn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkState();
        try {
            this.conn.clearWarnings();
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkState();
        return this.conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkState();
        this.conn.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkState();
        boolean useLocalSessionState = this.holder.getDataSource().isUseLocalSessionState();
        if (useLocalSessionState && holdability == this.holder.getUnderlyingHoldability()) {
            return;
        }
        this.conn.setHoldability(holdability);
        this.holder.setUnderlyingHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkState();
        if (!this.holder.isUnderlyingAutoCommit()) {
            this.createTransactionInfo();
        }
        return this.conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkState();
        try {
            return this.conn.setSavepoint();
        }
        catch (SQLException ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkState();
        return this.conn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkState();
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkState();
        return this.conn.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkState();
        return this.conn.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.holder == null) {
            throw new SQLClientInfoException();
        }
        this.conn.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.holder == null) {
            throw new SQLClientInfoException();
        }
        this.conn.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkState();
        return this.conn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkState();
        return this.conn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkState();
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkState();
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getConnectionEventListeners().add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getConnectionEventListeners().remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getStatementEventListeners().add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getStatementEventListeners().remove(listener);
    }

    public Throwable getDisableError() {
        return this.disableError;
    }

    public void checkState() throws SQLException {
        boolean asyncCloseEnabled = this.holder != null ? this.holder.getDataSource().isAsyncCloseConnectionEnable() : false;
        if (asyncCloseEnabled) {
            this.lock.lock();
            try {
                this.checkStateInternal();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.checkStateInternal();
        }
    }

    private void checkStateInternal() throws SQLException {
        if (this.holder == null) {
            if (this.disableError != null) {
                throw new SQLException("connection holder is null", this.disableError);
            }
            throw new SQLException("connection holder is null");
        }
        if (this.closed) {
            if (this.disableError != null) {
                throw new SQLException("connection closed", this.disableError);
            }
            throw new SQLException("connection closed");
        }
        if (this.disable) {
            if (this.disableError != null) {
                throw new SQLException("connection disabled", this.disableError);
            }
            throw new SQLException("connection disabled");
        }
    }

    public String toString() {
        if (this.conn != null) {
            return this.conn.toString();
        }
        return "closed-conn-" + System.identityHashCode(this);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    final void beforeExecute() {
        DruidConnectionHolder holder = this.holder;
        if (holder != null && holder.getDataSource().isRemoveAbandoned()) {
            this.running = true;
        }
    }

    final void afterExecute() {
        DruidConnectionHolder holder = this.holder;
        if (holder != null && holder.getDataSource().isRemoveAbandoned()) {
            this.running = false;
            holder.setLastActiveTimeMillis(System.currentTimeMillis());
        }
    }

    boolean isRunning() {
        return this.running;
    }

    public void abandond() {
        this.abandoned = true;
    }

    public long getPhysicalConnectNanoSpan() {
        return this.holder.getCreateNanoSpan();
    }

    public long getPhysicalConnectionUsedCount() {
        return this.holder.getUseCount();
    }

    public long getConnectNotEmptyWaitNanos() {
        return this.holder.getLastNotEmptyWaitNanos();
    }

    public Map<String, Object> getVariables() {
        return this.holder.variables;
    }

    public Map<String, Object> getGloablVariables() {
        return this.holder.globleVariables;
    }
}

