/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;

public class SQLSelectItem
extends SQLObjectImpl
implements SQLReplaceable {
    protected SQLExpr expr;
    protected String alias;
    protected boolean connectByRoot = false;
    protected transient long aliasHashCode64;

    public SQLSelectItem() {
    }

    public SQLSelectItem(SQLExpr expr) {
        this(expr, null);
    }

    public SQLSelectItem(SQLExpr expr, String alias) {
        this.expr = expr;
        this.alias = alias;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public SQLSelectItem(SQLExpr expr, String alias, boolean connectByRoot) {
        this.connectByRoot = connectByRoot;
        this.expr = expr;
        this.alias = alias;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    public String computeAlias() {
        String alias = this.getAlias();
        if (alias == null) {
            if (this.expr instanceof SQLIdentifierExpr) {
                alias = ((SQLIdentifierExpr)this.expr).getName();
            } else if (this.expr instanceof SQLPropertyExpr) {
                alias = ((SQLPropertyExpr)this.expr).getName();
            }
        }
        return SQLUtils.normalize(alias);
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.expr == null) {
            return null;
        }
        return this.expr.computeDataType();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.connectByRoot) {
            buf.append(" CONNECT_BY_ROOT ");
        }
        this.expr.output(buf);
        if (this.alias != null && this.alias.length() != 0) {
            buf.append(" AS ");
            buf.append(this.alias);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.expr);
        }
        visitor.endVisit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLSelectItem other = (SQLSelectItem)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
    }

    public boolean isConnectByRoot() {
        return this.connectByRoot;
    }

    public void setConnectByRoot(boolean connectByRoot) {
        this.connectByRoot = connectByRoot;
    }

    @Override
    public SQLSelectItem clone() {
        SQLSelectItem x = new SQLSelectItem();
        x.alias = this.alias;
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        x.connectByRoot = this.connectByRoot;
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (expr == expr) {
            this.setExpr(target);
            return true;
        }
        return false;
    }

    public boolean match(String alias) {
        if (alias == null) {
            return false;
        }
        long hash = FnvHash.hashCode64(alias);
        return this.match(hash);
    }

    public long alias_hash() {
        if (this.aliasHashCode64 == 0L) {
            this.aliasHashCode64 = FnvHash.hashCode64(this.alias);
        }
        return this.aliasHashCode64;
    }

    public boolean match(long alias_hash) {
        long hash = this.alias_hash();
        if (hash == alias_hash) {
            return true;
        }
        if (this.expr instanceof SQLAllColumnExpr) {
            SQLTableSource resolvedTableSource = ((SQLAllColumnExpr)this.expr).getResolvedTableSource();
            return resolvedTableSource != null && resolvedTableSource.findColumn(alias_hash) != null;
        }
        if (this.expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)this.expr).nameHashCode64() == alias_hash;
        }
        if (this.expr instanceof SQLPropertyExpr) {
            String ident = ((SQLPropertyExpr)this.expr).getName();
            if ("*".equals(ident)) {
                SQLTableSource resolvedTableSource = ((SQLPropertyExpr)this.expr).getResolvedTableSource();
                return resolvedTableSource != null && resolvedTableSource.findColumn(alias_hash) != null;
            }
            return ((SQLPropertyExpr)this.expr).nameHashCode64() == alias_hash;
        }
        return false;
    }

    @Override
    public String toString() {
        String dbType = null;
        if (this.parent instanceof OracleSQLObject) {
            dbType = "oracle";
        }
        return SQLUtils.toSQLString(this, dbType);
    }
}

